/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.Attribute;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.Persister;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.StringAttributeType;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

public abstract class AttributeType
implements AttributeDefinition {
    private MibObject m_mibObj;
    private String m_collectionName;
    private ResourceType m_resourceType;
    private AttributeGroupType m_groupType;

    protected AttributeType(ResourceType resourceType, String collectionName, MibObject mibObj, AttributeGroupType groupType) {
        this.m_resourceType = resourceType;
        this.m_collectionName = collectionName;
        this.m_mibObj = mibObj;
        this.m_groupType = groupType;
    }

    private MibObject getMibObj() {
        return this.m_mibObj;
    }

    protected String getCollectionName() {
        return this.m_collectionName;
    }

    public static List getCollectionTrackers(Collection objList) {
        ArrayList<CollectionTracker> trackers = new ArrayList<CollectionTracker>(objList.size());
        for (AttributeType attrType : objList) {
            trackers.add(attrType.getMibObj().getCollectionTracker());
        }
        return trackers;
    }

    public static AttributeType create(ResourceType resourceType, String collectionName, MibObject mibObj, AttributeGroupType groupType) {
        if (NumericAttributeType.supportsType(mibObj.getType())) {
            return new NumericAttributeType(resourceType, collectionName, mibObj, groupType);
        }
        if (StringAttributeType.supportsType(mibObj.getType())) {
            return new StringAttributeType(resourceType, collectionName, mibObj, groupType);
        }
        throw new IllegalArgumentException("No support exists for AttributeType '" + mibObj.getType() + "' for MIB object: " + mibObj);
    }

    public AttributeGroupType getGroupType() {
        return this.m_groupType;
    }

    public String getGroupName() {
        return this.m_groupType.getName();
    }

    public String getAlias() {
        return this.m_mibObj.getAlias();
    }

    public String getOid() {
        return this.m_mibObj.getOid();
    }

    public String getInstance() {
        return this.m_mibObj.getInstance();
    }

    public String getType() {
        return this.m_mibObj.getType();
    }

    SnmpObjId getSnmpObjId() {
        return this.m_mibObj.getSnmpObjId();
    }

    public String getName() {
        return this.getAlias();
    }

    protected abstract void storeAttribute(Attribute var1, Persister var2);

    public void storeResult(CollectionSet collectionSet, SNMPCollectorEntry entry, SnmpObjId base, SnmpInstId inst, SnmpValue val) {
        this.log().info((Object)("Setting attribute: " + this + ".[" + inst + "] = '" + val + "'"));
        CollectionResource resource = null;
        resource = this.getAlias().equals("ifAlias") ? this.m_resourceType.findAliasedResource(inst, val.toString()) : this.m_resourceType.findResource(inst);
        if (resource == null) {
            collectionSet.notifyIfNotFound(this, base, inst, val);
        } else {
            resource.setAttributeValue(this, val);
        }
    }

    public String toString() {
        return this.getAlias() + " [" + this.getOid() + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttributeType) {
            AttributeType attrType = (AttributeType)obj;
            return attrType.m_resourceType.equals(this.m_resourceType) && attrType.getAlias().equals(this.getAlias());
        }
        return false;
    }

    public int hashCode() {
        return this.getAlias().hashCode();
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String getGroupIfType() {
        return this.m_groupType.getIfType();
    }

    public boolean matches(SnmpObjId base, SnmpInstId inst) {
        if (!base.equals((Object)this.getSnmpObjId())) {
            return false;
        }
        if (this.getInstance().equals("ifIndex") || this.m_mibObj.getResourceType() != null) {
            return true;
        }
        return this.getInstance().equals(inst.toString());
    }
}

