/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.Attribute;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.ServiceParameters;

public class AttributeGroup {
    private CollectionResource m_resource;
    private AttributeGroupType m_groupType;
    private Set m_attributes = new HashSet();

    public AttributeGroup(CollectionResource resource, AttributeGroupType groupType) {
        this.m_resource = resource;
        this.m_groupType = groupType;
    }

    public String getName() {
        return this.m_groupType.getName();
    }

    public CollectionResource getResource() {
        return this.m_resource;
    }

    public Collection getAttributes() {
        return this.m_attributes;
    }

    public void addAttribute(Attribute attr) {
        this.m_attributes.add(attr);
    }

    public void visit(CollectionSetVisitor visitor) {
        this.log().debug((Object)("Visiting Group " + this));
        visitor.visitGroup(this);
        for (Attribute attr : this.getAttributes()) {
            attr.visit(visitor);
        }
        visitor.completeGroup(this);
    }

    public boolean shouldPersist(ServiceParameters params) {
        boolean shouldPersist = this.doShouldPersist();
        this.log().debug((Object)(this + ".shouldPersist = " + shouldPersist));
        return shouldPersist;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private boolean doShouldPersist() {
        if ("ignore".equals(this.getIfType())) {
            return true;
        }
        if ("all".equals(this.getIfType())) {
            return true;
        }
        String type = String.valueOf(this.m_resource.getType());
        if (type.equals(this.getIfType())) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.getIfType(), ",");
        while (tokenizer.hasMoreTokens()) {
            if (!type.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    private String getIfType() {
        return this.m_groupType.getIfType();
    }

    public AttributeGroupType getGroupType() {
        return this.m_groupType;
    }

    public String toString() {
        return this.m_groupType + " for " + this.m_resource;
    }
}

