/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.Collection;
import org.opennms.netmgt.collectd.AliasedGroup;
import org.opennms.netmgt.collectd.AttributeGroup;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.model.RrdRepository;

public class AliasedResource
extends CollectionResource {
    private IfInfo m_ifInfo;
    private String m_ifAliasComment;
    private String m_domain;
    private String m_ifAlias;

    public AliasedResource(ResourceType resourceType, String domain, IfInfo ifInfo, String ifAliasComment, String ifAlias) {
        super(resourceType);
        this.m_domain = domain;
        this.m_ifInfo = ifInfo;
        this.m_ifAliasComment = ifAliasComment;
        this.m_ifAlias = ifAlias;
    }

    public IfInfo getIfInfo() {
        return this.m_ifInfo;
    }

    public Collection getAttributeTypes() {
        return this.m_ifInfo.getAttributeTypes();
    }

    String getAliasDir() {
        return this.getIfInfo().getAliasDir(this.m_ifAlias, this.m_ifAliasComment);
    }

    public String getDomain() {
        return this.m_domain;
    }

    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File domainDir = new File(rrdBaseDir, this.getDomain());
        File aliasDir = new File(domainDir, this.getAliasDir());
        return aliasDir;
    }

    public CollectionAgent getCollectionAgent() {
        return this.getIfInfo().getCollectionAgent();
    }

    public String toString() {
        return this.getDomain() + '/' + this.getAliasDir() + " [" + this.m_ifInfo + ']';
    }

    public boolean rescanNeeded() {
        boolean outOfDate = this.getIfInfo().currentAliasIsOutOfDate(this.m_ifAlias);
        if (outOfDate) {
            this.getIfInfo().setIfAlias(this.m_ifAlias);
        }
        return outOfDate;
    }

    public boolean isScheduledForCollection() {
        return this.getIfInfo().isScheduledForCollection();
    }

    public boolean shouldPersist(ServiceParameters serviceParameters) {
        boolean shdPrsist = serviceParameters.aliasesEnabled() && this.getAliasDir() != null && !this.getAliasDir().equals("") && (this.isScheduledForCollection() || serviceParameters.forceStoreByAlias(this.getAliasDir()));
        this.log().debug((Object)("shouldPersist = " + shdPrsist));
        return shdPrsist;
    }

    protected int getType() {
        return this.getIfInfo().getType();
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitResource(this);
        for (AttributeGroup group : this.getGroups()) {
            AliasedGroup aliased = new AliasedGroup((CollectionResource)this, group);
            ((AttributeGroup)aliased).visit(visitor);
        }
        visitor.completeResource(this);
    }

    public Collection getGroups() {
        return this.getIfInfo().getGroups();
    }
}

