/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AliasedAttribute;
import org.opennms.netmgt.collectd.Attribute;
import org.opennms.netmgt.collectd.AttributeGroup;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.ServiceParameters;

public class AliasedGroup
extends AttributeGroup {
    AttributeGroup m_group;

    public AliasedGroup(CollectionResource resource, AttributeGroup group) {
        super(resource, group.getGroupType());
        this.m_group = group;
    }

    public void addAttribute(Attribute attr) {
        this.m_group.addAttribute(attr);
    }

    public boolean equals(Object obj) {
        return this.m_group.equals(obj);
    }

    public Collection getAttributes() {
        return this.m_group.getAttributes();
    }

    public AttributeGroupType getGroupType() {
        return this.m_group.getGroupType();
    }

    public String getName() {
        return this.m_group.getName();
    }

    public int hashCode() {
        return this.m_group.hashCode();
    }

    public boolean shouldPersist(ServiceParameters params) {
        return this.m_group.shouldPersist(params);
    }

    public String toString() {
        return this.m_group.toString();
    }

    Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitGroup(this);
        for (Attribute attr : this.getAttributes()) {
            AliasedAttribute aliased = new AliasedAttribute(this.getResource(), attr);
            this.log().debug((Object)("visiting at aliased  = " + aliased));
            aliased.visit(visitor);
        }
        visitor.completeGroup(this);
    }
}

