/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import java.net.InetAddress;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.IfTableEntry;
import org.opennms.netmgt.capsd.snmp.SnmpTable;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;

public final class IfTable
extends SnmpTable {
    public IfTable(InetAddress address) {
        super(address, "ifTable", IfTableEntry.ms_elemList);
    }

    protected SnmpTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new IfTableEntry();
    }

    protected final Category log() {
        return ThreadCategory.getInstance(IfTable.class);
    }

    public int getOperStatus(int ifIndex) {
        if (this.getEntries() == null) {
            return -1;
        }
        for (IfTableEntry entry : this.getEntries()) {
            Integer ifStatus;
            Integer ndx = entry.getIfIndex();
            if (ndx == null || ndx != ifIndex || (ifStatus = entry.getIfOperStatus()) == null) continue;
            return ifStatus;
        }
        return -1;
    }

    public int getAdminStatus(int ifIndex) {
        if (this.getEntries() == null) {
            return -1;
        }
        for (IfTableEntry entry : this.getEntries()) {
            Integer ifStatus;
            Integer ndx = entry.getIfIndex();
            if (ndx == null || ndx != ifIndex || (ifStatus = entry.getIfAdminStatus()) == null) continue;
            return ifStatus;
        }
        return -1;
    }

    public int getIfType(int ifIndex) {
        if (this.getEntries() == null) {
            return -1;
        }
        for (IfTableEntry entry : this.getEntries()) {
            Integer ifType;
            Integer ndx = entry.getIfIndex();
            if (ndx == null || ndx != ifIndex || (ifType = entry.getIfType()) == null) continue;
            return ifType;
        }
        return -1;
    }

    public String getIfDescr(int ifIndex) {
        String ifDescr = null;
        if (this.getEntries() != null) {
            for (IfTableEntry entry : this.getEntries()) {
                Integer ndx = entry.getIfIndex();
                if (ndx == null || ndx != ifIndex) continue;
                ifDescr = entry.getIfDescr();
            }
        }
        return ifDescr;
    }

    public Long getIfSpeed(int ifIndex) {
        Long ifSpeed = null;
        if (this.getEntries() != null) {
            for (IfTableEntry entry : this.getEntries()) {
                Integer ndx = entry.getIfIndex();
                if (ndx == null || ndx != ifIndex) continue;
                ifSpeed = entry.getIfSpeed();
            }
        }
        return ifSpeed;
    }

    public String getPhysAddr(int ifIndex) {
        String physAddr = null;
        if (this.getEntries() != null) {
            for (IfTableEntry entry : this.getEntries()) {
                Integer ndx = entry.getIfIndex();
                if (ndx == null || ndx != ifIndex) continue;
                physAddr = entry.getPhysAddr();
            }
        }
        return physAddr;
    }
}

