/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import jcifs.netbios.NbtAddress;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;

public final class SmbPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "SMB";

    private boolean isSmb(InetAddress host) {
        Category log = ThreadCategory.getInstance(this.getClass());
        boolean isAServer = false;
        try {
            NbtAddress nbtAddr = NbtAddress.getByName((String)host.getHostAddress());
            if (nbtAddr.getHostName().equals(host.getHostAddress())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SmbPlugin: failed to retrieve SMB name for " + host.getHostAddress()));
                }
            } else {
                isAServer = true;
            }
        }
        catch (UnknownHostException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("SmbPlugin: UnknownHostException: " + e.getMessage()));
            }
        }
        catch (Throwable t) {
            log.error((Object)("SmbPlugin: An undeclared throwable exception was caught checking host " + host.getHostAddress()), t);
        }
        return isAServer;
    }

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean isProtocolSupported(InetAddress address) {
        return this.isSmb(address);
    }

    public boolean isProtocolSupported(InetAddress address, Map qualifiers) {
        return this.isSmb(address);
    }
}

