/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.capsd.PluginManager;
import org.opennms.netmgt.capsd.ReparentViaSmb;
import org.opennms.netmgt.capsd.RescanProcessor;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;

final class Scheduler
implements Runnable,
PausableFiber {
    private static final String FIBER_NAME = "Capsd Scheduler";
    private static final String SQL_RETRIEVE_NODES = "SELECT nodeid FROM node WHERE nodetype != 'D'";
    private static final String SQL_GET_LAST_POLL_TIME = "SELECT iplastcapsdpoll FROM ipinterface WHERE nodeid=? AND (ismanaged = 'M' OR ismanaged = 'N')";
    private static final int SMB_REPARENTING_IDENTIFIER = -1;
    private String m_name;
    private int m_status;
    private Thread m_worker;
    private List m_knownNodes;
    private long m_interval;
    private long m_initialSleep;
    private FifoQueue m_rescanQ;
    private CapsdDbSyncer m_capsdDbSyncer;
    private PluginManager m_pluginManager;

    Scheduler(CapsdDbSyncer syncer, PluginManager pluginManager, FifoQueue rescanQ) throws SQLException {
        this.m_capsdDbSyncer = syncer;
        this.m_pluginManager = pluginManager;
        this.m_rescanQ = rescanQ;
        this.m_name = FIBER_NAME;
        this.m_status = 0;
        this.m_worker = null;
        this.m_knownNodes = Collections.synchronizedList(new LinkedList());
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_interval = CapsdConfigFactory.getInstance().getRescanFrequency();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scheduler: rescan interval(millis): " + this.m_interval));
        }
        this.m_initialSleep = CapsdConfigFactory.getInstance().getInitialSleepTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scheduler: initial rescan sleep time(millis): " + this.m_initialSleep));
        }
        Date lastSmbReparenting = new Date();
        lastSmbReparenting.setTime(System.currentTimeMillis() - this.m_interval);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Scheduler: scheduling SMB reparenting...");
        }
        NodeInfo smbInfo = new NodeInfo(-1, lastSmbReparenting, this.m_interval);
        this.m_knownNodes.add(smbInfo);
        this.loadKnownNodes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scheduler: done loading known nodes, node count: " + this.m_knownNodes.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKnownNodes() throws SQLException {
        Category log = ThreadCategory.getInstance(this.getClass());
        Connection db = null;
        PreparedStatement nodeStmt = null;
        Statement ifStmt = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            nodeStmt = db.prepareStatement(SQL_RETRIEVE_NODES);
            ifStmt = db.prepareStatement(SQL_GET_LAST_POLL_TIME);
            ResultSet rs = nodeStmt.executeQuery();
            while (rs.next()) {
                ResultSet rset;
                int nodeId = rs.getInt(1);
                ifStmt.setInt(1, nodeId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("loadKnownNodes: retrieved nodeid " + nodeId + ", now getting last poll time."));
                }
                if ((rset = ifStmt.executeQuery()).next()) {
                    Timestamp lastPolled = rset.getTimestamp(1);
                    if (lastPolled == null || rset.wasNull()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("loadKnownNodes: adding node " + nodeId + " with last poll time " + lastPolled));
                    }
                    NodeInfo nodeInfo = new NodeInfo(nodeId, lastPolled, this.m_interval);
                    this.m_knownNodes.add(nodeInfo);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Node w/ nodeid " + nodeId + " has no managed interfaces from which to retrieve a last poll time...it will not be scheduled."));
            }
        }
        finally {
            try {
                if (nodeStmt != null) {
                    nodeStmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (ifStmt != null) {
                    ifStmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleNode(int nodeId) throws SQLException {
        Category log = ThreadCategory.getInstance(this.getClass());
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            PreparedStatement ifStmt = db.prepareStatement(SQL_GET_LAST_POLL_TIME);
            ifStmt.setInt(1, nodeId);
            ResultSet rset = ifStmt.executeQuery();
            if (rset.next()) {
                Timestamp lastPolled = rset.getTimestamp(1);
                if (lastPolled != null && !rset.wasNull()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("scheduleNode: adding node " + nodeId + " with last poll time " + lastPolled));
                    }
                    this.m_knownNodes.add(new NodeInfo(nodeId, lastPolled, this.m_interval));
                }
            } else {
                log.warn((Object)("scheduleNode: Failed to retrieve last polled time from database for nodeid " + nodeId));
            }
        }
        finally {
            if (db != null) {
                try {
                    db.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unscheduleNode(int nodeId) {
        List list = this.m_knownNodes;
        synchronized (list) {
            for (NodeInfo nodeInfo : this.m_knownNodes) {
                if (nodeInfo.getNodeId() != nodeId) continue;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("unscheduleNode: removing node " + nodeId + " from the scheduler."));
                this.m_knownNodes.remove(nodeInfo);
                break;
            }
        }
    }

    void forceRescan(int nodeId) {
        NodeInfo nodeInfo = new NodeInfo(nodeId, null, -1L);
        try {
            this.m_rescanQ.add((Object)new RescanProcessor(nodeInfo, true, this.m_capsdDbSyncer, this.m_pluginManager));
        }
        catch (FifoQueueException e) {
            ThreadCategory.getInstance(this.getClass()).error((Object)("forceRescan: Failed to add node " + nodeId + " to the rescan queue."), (Throwable)e);
        }
        catch (InterruptedException e) {
            ThreadCategory.getInstance(this.getClass()).error((Object)("forceRescan: Failed to add node " + nodeId + " to the rescan queue."), (Throwable)e);
        }
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already run or is running");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
        this.m_status = 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Scheduler.start: scheduler started");
        }
    }

    public synchronized void stop() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_status = 3;
        this.m_worker.interrupt();
        log.debug((Object)"Scheduler.stop: scheduler stopped");
    }

    public synchronized void pause() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 6) {
            return;
        }
        this.m_status = 5;
        this.notifyAll();
    }

    public synchronized void resume() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 2) {
            return;
        }
        this.m_status = 7;
        this.notifyAll();
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    public String getName() {
        return FIBER_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Category log = ThreadCategory.getInstance(this.getClass());
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.m_status = 2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Scheduler.run: scheduler running");
        }
        boolean firstPass = true;
        while (true) {
            Scheduler scheduler2 = this;
            synchronized (scheduler2) {
                if (this.m_status != 2 && this.m_status != 6 && this.m_status != 5 && this.m_status != 7) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Scheduler.run: status = " + this.m_status + ", time to exit"));
                    }
                    break;
                }
            }
            if (firstPass) {
                firstPass = false;
                scheduler2 = this;
                synchronized (scheduler2) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Scheduler.run: initial sleep configured for " + this.m_initialSleep + "ms...sleeping..."));
                        }
                        this.wait(this.m_initialSleep);
                    }
                    catch (InterruptedException ex) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Scheduler.run: interrupted exception during initial sleep...exiting.");
                        }
                        break;
                    }
                }
            }
            int added = 0;
            Object object = this.m_knownNodes;
            synchronized (object) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Scheduler.run: iterating over known nodes list to schedule...");
                }
                for (NodeInfo node : this.m_knownNodes) {
                    if (node.isScheduled() || !node.timeForRescan()) continue;
                    try {
                        node.setScheduled(true);
                        if (node.getNodeId() == -1) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Scheduler.run: time for reparenting via SMB...");
                            }
                            Connection db = null;
                            try {
                                db = DataSourceFactory.getInstance().getConnection();
                                ReparentViaSmb reparenter = new ReparentViaSmb(db);
                                try {
                                    reparenter.sync();
                                }
                                catch (SQLException sqlE) {
                                    log.error((Object)"Unexpected database error during SMB reparenting", (Throwable)sqlE);
                                }
                                catch (Throwable t) {
                                    log.error((Object)"Unexpected error during SMB reparenting", t);
                                }
                            }
                            catch (SQLException sqlE) {
                                log.error((Object)"Unable to get database connection from the factory.", (Throwable)sqlE);
                            }
                            finally {
                                if (db != null) {
                                    try {
                                        db.close();
                                    }
                                    catch (Exception e) {}
                                }
                            }
                            node.setLastScanned(new Date());
                            node.setScheduled(false);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Scheduler.run: SMB reparenting completed...");
                            continue;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Scheduler.run: adding node " + node.getNodeId() + " to the rescan queue."));
                        }
                        this.m_rescanQ.add((Object)new RescanProcessor(node, false, this.m_capsdDbSyncer, this.m_pluginManager));
                        ++added;
                    }
                    catch (InterruptedException ex) {
                        log.info((Object)"Scheduler.schedule: failed to add new node to rescan queue", (Throwable)ex);
                        throw new UndeclaredThrowableException(ex);
                    }
                    catch (FifoQueueException ex) {
                        log.info((Object)"Scheduler.schedule: failed to add new node to rescan queue", (Throwable)ex);
                        throw new UndeclaredThrowableException(ex);
                    }
                }
            }
            object = this;
            synchronized (object) {
                if (added == 0) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        }
        log.debug((Object)"Scheduler.run: scheduler exiting, state = STOPPED");
        Scheduler scheduler3 = this;
        synchronized (scheduler3) {
            this.m_status = 4;
        }
    }

    final class NodeInfo {
        int m_nodeId;
        Timestamp m_lastScanned;
        long m_interval;
        boolean m_scheduled;

        NodeInfo(int nodeId, Timestamp lastScanned, long interval) {
            this.m_nodeId = nodeId;
            this.m_lastScanned = lastScanned;
            this.m_interval = interval;
            this.m_scheduled = false;
        }

        NodeInfo(int nodeId, Date lastScanned, long interval) {
            this.m_nodeId = nodeId;
            this.m_lastScanned = new Timestamp(lastScanned.getTime());
            this.m_interval = interval;
            this.m_scheduled = false;
        }

        boolean isScheduled() {
            return this.m_scheduled;
        }

        int getNodeId() {
            return this.m_nodeId;
        }

        Timestamp getLastScanned() {
            return this.m_lastScanned;
        }

        long getRescanInterval() {
            return this.m_interval;
        }

        void setScheduled(boolean scheduled) {
            this.m_scheduled = scheduled;
        }

        void setLastScanned(Date lastScanned) {
            this.m_lastScanned = new Timestamp(lastScanned.getTime());
        }

        void setLastScanned(Timestamp lastScanned) {
            this.m_lastScanned = lastScanned;
        }

        boolean timeForRescan() {
            return System.currentTimeMillis() >= this.m_lastScanned.getTime() + this.m_interval;
        }
    }
}

