/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.capsd.JdbcCapsdDbSyncer;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.springframework.util.Assert;

public final class CapsdDbSyncerFactory {
    private static CapsdDbSyncer s_singleton = null;

    private CapsdDbSyncerFactory() {
    }

    public static synchronized void init() {
        if (CapsdDbSyncerFactory.isLoaded()) {
            return;
        }
        CapsdDbSyncerFactory.log().debug((Object)"init: Performing default initialization using JdbcCapsdDbSyncer");
        JdbcCapsdDbSyncer syncer = new JdbcCapsdDbSyncer();
        syncer.setOpennmsServerConfig(OpennmsServerConfigFactory.getInstance());
        syncer.setCapsdConfig(CapsdConfigFactory.getInstance());
        syncer.setPollerConfig(PollerConfigFactory.getInstance());
        syncer.setCollectdConfig(CollectdConfigFactory.getInstance());
        syncer.afterPropertiesSet();
        CapsdDbSyncerFactory.setInstance(syncer);
    }

    public static synchronized CapsdDbSyncer getInstance() {
        Assert.state((boolean)CapsdDbSyncerFactory.isLoaded(), (String)"The factory has not been initialized");
        return s_singleton;
    }

    public static synchronized void setInstance(JdbcCapsdDbSyncer singleton) {
        s_singleton = singleton;
    }

    private static boolean isLoaded() {
        return s_singleton != null;
    }

    private static Category log() {
        return ThreadCategory.getInstance(CapsdDbSyncerFactory.class);
    }
}

