/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.archive;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeConverter;
import org.opennms.netmgt.archive.ArchiverException;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.EventsArchiverConfigFactory;

public class EventsArchiver {
    private static final String DB_SELECT_EVENTS_TO_ARCHIVE = "SELECT * FROM events WHERE (eventcreatetime < ?)";
    private static final String DB_DELETE_EVENT = "DELETE FROM events WHERE (eventID = ?)";
    private static final String EVENT_ID = "eventID";
    private static final String EVENT_LOG = "eventLog";
    private static final String EVENT_DISPLAY = "eventDisplay";
    private static final String EVENT_ACK_USER = "eventAckUser";
    private static final String MSG_YES = "Y";
    private static final String MSG_NO = "N";
    private Category m_logCat;
    private Category m_archCat;
    private long m_archAge;
    private String m_archSeparator;
    private Connection m_conn;
    private PreparedStatement m_eventsGetStmt;
    private PreparedStatement m_eventDeleteStmt;

    private void init() throws ArchiverException {
        long archAge;
        EventsArchiverConfigFactory eaFactory;
        ThreadCategory.setPrefix((String)"OpenNMS.Archiver.Events");
        this.m_logCat = ThreadCategory.getInstance((String)"OpenNMS.Archiver.Events");
        this.m_archCat = Category.getInstance((String)"EventsArchiver");
        this.m_archCat.setAdditivity(false);
        try {
            EventsArchiverConfigFactory.init();
            eaFactory = EventsArchiverConfigFactory.getInstance();
        }
        catch (MarshalException ex) {
            this.m_logCat.fatal((Object)"MarshalException", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.m_logCat.fatal((Object)"ValidationException", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.m_logCat.fatal((Object)"IOException", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        String archAgeStr = eaFactory.getArchiveAge();
        try {
            archAge = TimeConverter.convertToMillis((String)archAgeStr);
        }
        catch (NumberFormatException nfe) {
            throw new ArchiverException("Archive age: " + archAgeStr + "- Incorrect format " + nfe.getMessage());
        }
        this.m_archAge = System.currentTimeMillis() - archAge;
        String separator = eaFactory.getSeparator();
        this.m_archSeparator = separator == null ? "#" : separator;
        if (this.m_logCat.isInfoEnabled()) {
            archAgeStr = new Date(this.m_archAge).toString();
            this.m_logCat.info((Object)("Events archive age specified = " + archAgeStr));
            this.m_logCat.info((Object)("Events archive age in millisconds = " + archAge));
            this.m_logCat.info((Object)("Events created before '" + archAgeStr + " ' will be deleted"));
            this.m_logCat.info((Object)("Separator to be used in archive: " + this.m_archSeparator));
        }
        try {
            DataSourceFactory.init();
            this.m_conn = DataSourceFactory.getInstance().getConnection();
        }
        catch (IOException e) {
            this.m_logCat.fatal((Object)"IOException while initializing database", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (MarshalException e) {
            this.m_logCat.fatal((Object)"MarshalException while initializing database", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.m_logCat.fatal((Object)"ValidationException while initializing database", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            this.m_logCat.fatal((Object)"PropertyVetoException while initializing database", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            this.m_logCat.fatal((Object)"SQLException while initializing database", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            this.m_logCat.fatal((Object)"ClassNotFoundException while initializing database", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private boolean removeEvent(String eventID) {
        try {
            this.m_eventDeleteStmt.setString(1, eventID);
            this.m_eventDeleteStmt.executeUpdate();
        }
        catch (SQLException sqle) {
            this.m_logCat.error((Object)("Unable to delete event '" + eventID + "': " + sqle.getMessage()));
            return false;
        }
        if (this.m_logCat.isDebugEnabled()) {
            this.m_logCat.debug((Object)("EventID: " + eventID + " removed from events table"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveEvents() {
        int archCount = 0;
        int remCount = 0;
        ResultSet eventsRS = null;
        try {
            this.m_eventsGetStmt.setTimestamp(1, new Timestamp(this.m_archAge));
            eventsRS = this.m_eventsGetStmt.executeQuery();
            int colCount = eventsRS.getMetaData().getColumnCount();
            while (eventsRS.next()) {
                boolean ret;
                String eventID = eventsRS.getString(EVENT_ID);
                String eventUEI = eventsRS.getString("eventUei");
                String eventLog = eventsRS.getString(EVENT_LOG);
                String eventDisplay = eventsRS.getString(EVENT_DISPLAY);
                String eventAckUser = eventsRS.getString(EVENT_ACK_USER);
                this.m_logCat.debug((Object)("Event id: " + eventID + " uei: " + eventUEI + " log: " + eventLog + " display: " + eventDisplay + " eventAck: " + eventAckUser));
                if (eventLog.equals(MSG_NO) && eventDisplay.equals(MSG_NO)) {
                    ret = this.removeEvent(eventID);
                    if (!ret) continue;
                    ++remCount;
                    continue;
                }
                if (eventLog.equals(MSG_YES) && eventDisplay.equals(MSG_NO)) {
                    ret = this.removeEvent(eventID);
                    if (!ret) continue;
                    this.sendToArchive(eventsRS, colCount);
                    if (this.m_logCat.isDebugEnabled()) {
                        this.m_logCat.debug((Object)("eventID " + eventID + " archived"));
                    }
                    ++archCount;
                    ++remCount;
                    continue;
                }
                if (eventLog.equals(MSG_NO) && eventDisplay.equals(MSG_YES)) {
                    if (eventAckUser == null || !(ret = this.removeEvent(eventID))) continue;
                    ++remCount;
                    continue;
                }
                if (eventAckUser == null || !(ret = this.removeEvent(eventID))) continue;
                this.sendToArchive(eventsRS, colCount);
                if (this.m_logCat.isDebugEnabled()) {
                    this.m_logCat.debug((Object)("eventID " + eventID + " archived"));
                }
                ++archCount;
                ++remCount;
            }
            this.m_logCat.info((Object)("Number of events removed from the event table: " + remCount));
            this.m_logCat.info((Object)("Number of events sent to the archive: " + archCount));
        }
        catch (Exception oe) {
            this.m_logCat.error((Object)"EventsArchiver: Error reading events for archival: ");
            this.m_logCat.error((Object)oe.getMessage());
        }
        finally {
            try {
                eventsRS.close();
            }
            catch (Exception e) {
                this.m_logCat.info((Object)("EventsArchiver: Exception while events result set: message -> " + e.getMessage()));
            }
        }
    }

    private void sendToArchive(ResultSet eventsRS, int colCount) throws SQLException {
        StringBuffer outBuf = new StringBuffer();
        for (int index = 1; index <= colCount; ++index) {
            String colValue = eventsRS.getString(index);
            if (index == 1) {
                outBuf.append(colValue);
                continue;
            }
            outBuf.append(this.m_archSeparator + colValue);
        }
        String outBufStr = outBuf.toString();
        this.m_archCat.fatal((Object)outBufStr);
    }

    private void close() {
        try {
            this.m_eventsGetStmt.close();
            this.m_eventDeleteStmt.close();
            this.m_conn.close();
        }
        catch (SQLException e) {
            this.m_logCat.warn((Object)("Error while closing database statements and connection: message -> " + e.getMessage()));
        }
        Category.shutdown();
    }

    public EventsArchiver() throws ArchiverException {
        this.init();
        try {
            this.m_eventsGetStmt = this.m_conn.prepareStatement(DB_SELECT_EVENTS_TO_ARCHIVE);
            this.m_eventDeleteStmt = this.m_conn.prepareStatement(DB_DELETE_EVENT);
        }
        catch (SQLException e) {
            this.m_logCat.error((Object)"EventsArchiver: Exception in opening the database connection or in the prepared statement for the get events");
            this.m_logCat.error((Object)e);
            throw new ArchiverException("EventsArchiver: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        try {
            EventsArchiver ea = new EventsArchiver();
            ea.archiveEvents();
            ea.close();
        }
        catch (ArchiverException ae) {
            System.err.println(ae.getMessage());
        }
    }
}

