/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.rrdtool;

import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.springframework.util.Assert;

public final class Interface {
    private static final String LIBRARY_NAME = "jrrd";
    private static final String PROPERTY_NAME = "opennms.library.jrrd";
    private static Interface s_singleton = null;

    public static synchronized native String[] launch(String var0);

    public static synchronized void init() throws SecurityException, UnsatisfiedLinkError {
        if (Interface.isLoaded()) {
            return;
        }
        Interface.setInstance(new Interface());
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private static boolean isLoaded() {
        return s_singleton != null;
    }

    public static synchronized void reload() throws SecurityException, UnsatisfiedLinkError {
        Interface.setInstance(null);
        Interface.init();
    }

    private Interface() throws SecurityException, UnsatisfiedLinkError {
        String property = System.getProperty(PROPERTY_NAME);
        if (property != null) {
            this.log().debug((Object)("System property 'opennms.library.jrrd' set to '" + System.getProperty(PROPERTY_NAME) + ".  Attempting to load " + LIBRARY_NAME + " library from this location."));
            System.load(property);
        } else {
            this.log().debug((Object)"System property 'opennms.library.jrrd' not set.  Attempting to load library using System.loadLibrary(\"jrrd\").");
            System.loadLibrary(LIBRARY_NAME);
        }
        this.log().info((Object)"Successfully loaded jrrd library.");
    }

    public static synchronized Interface getInstance() {
        Assert.state((boolean)Interface.isLoaded(), (String)"The RRD JNI interface has not been initialized");
        return s_singleton;
    }

    public static synchronized void setInstance(Interface instance) {
        s_singleton = instance;
    }

    public static void main(String[] argv) {
        try {
            Interface.reload();
            String filename = argv[0];
            System.out.println("filename=" + filename);
            String cmd = "create \"" + filename + "\" --start N" + " --step 900 DS:test:COUNTER:900:0:100 RRA:MIN:0.5:1:1000";
            System.out.println("issuing RRD cmd: " + cmd);
            Interface.launch(cmd);
            System.out.println("command completed.");
        }
        catch (Throwable t) {
            System.err.println("unexpected error, reason: " + t);
            t.printStackTrace();
        }
    }
}

