/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.tests;

import java.rmi.RMISecurityManager;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.oss.ApplicationContext;
import javax.oss.fm.monitor.AlarmKey;
import javax.oss.fm.monitor.AlarmValue;
import javax.oss.fm.monitor.JVTAlarmMonitorHome;
import javax.oss.fm.monitor.JVTAlarmMonitorSession;
import javax.rmi.PortableRemoteObject;
import org.openoss.ossj.fm.monitor.j2ee.AlarmMonitor;
import org.openoss.ossj.jvt.fm.monitor.OOSSAlarmKey;
import org.openoss.ossj.jvt.fm.monitor.OOSSAlarmValue;
import org.openoss.ossj.jvt.fm.monitor.OOSSApplicationContext;
import org.openoss.ossj.tests.NewFMTest;

public class AlarmAdding {
    private JVTAlarmMonitorHome home;
    private JVTAlarmMonitorSession session;
    private AlarmMonitor alarmInternals;
    private Object ref;
    private AlarmMonitor am = null;
    private Properties props = new Properties();
    private Properties env = new Properties();

    public static void main(String[] args) {
        AlarmAdding alarmAdding = new AlarmAdding();
        alarmAdding.test();
    }

    public void test() {
        try {
            NewFMTest test;
            AlarmKey _ak;
            System.out.println("starting init");
            this.init();
            System.out.println("init successful");
            OOSSAlarmValue[] alarms = new OOSSAlarmValue[10];
            for (int i = 0; i < 10; ++i) {
                alarms[i] = this.createAlarmTemplate();
                AlarmKey _ak2 = alarms[i].getAlarmKey();
                _ak2.setAlarmPrimaryKey(Integer.toString(1100 + i));
                alarms[0].setAlarmKey(_ak2);
            }
            try {
                System.out.println("force alarm list rebuild");
                this.am.rebuildAlarmList("Test forced rebuild of alarm list");
            }
            catch (Exception ex) {
                System.out.println("Test forced rebuild of alarm list failed");
                ex.printStackTrace();
            }
            try {
                System.out.println("SENDING ALARM alarm[0]");
                _ak = alarms[0].getAlarmKey();
                _ak.setAlarmPrimaryKey(Integer.toString(1000));
                alarms[0].setAlarmKey(_ak);
                test = new NewFMTest();
                test.printAllAlarmData((AlarmValue)alarms[0]);
                this.am.updateAlarm((AlarmValue)alarms[0]);
            }
            catch (Exception ex) {
                System.out.println("add alarm[0] failed");
                ex.printStackTrace();
            }
            try {
                System.out.println("add alarm[1]");
                this.am.updateAlarm((AlarmValue)alarms[1]);
            }
            catch (Exception ex) {
                System.out.println("add alarm[1] failed");
                ex.printStackTrace();
            }
            try {
                System.out.println("add alarm[2]");
                this.am.updateAlarm((AlarmValue)alarms[2]);
            }
            catch (Exception ex) {
                System.out.println("add alarm[2] failed");
                ex.printStackTrace();
            }
            try {
                System.out.println("ACK ALARM alarm[0]");
                _ak = alarms[0].getAlarmKey();
                _ak.setAlarmPrimaryKey(Integer.toString(1000));
                alarms[0].setAlarmKey(_ak);
                alarms[0].setAlarmAckState(1);
                test = new NewFMTest();
                test.printAllAlarmData((AlarmValue)alarms[0]);
                this.am.updateAlarm((AlarmValue)alarms[0]);
            }
            catch (Exception ex) {
                System.out.println("add alarm[0] failed");
                ex.printStackTrace();
            }
            try {
                System.out.println("CLR ALARM alarm[0]");
                _ak = alarms[0].getAlarmKey();
                _ak.setAlarmPrimaryKey(Integer.toString(1000));
                alarms[0].setAlarmKey(_ak);
                alarms[0].setPerceivedSeverity((short)6);
                test = new NewFMTest();
                test.printAllAlarmData((AlarmValue)alarms[0]);
                this.am.updateAlarm((AlarmValue)alarms[0]);
            }
            catch (Exception ex) {
                System.out.println("add alarm[0] failed");
                ex.printStackTrace();
            }
            try {
                System.out.println("delete alarm[0]");
                this.am.deleteAlarm((AlarmValue)alarms[0]);
            }
            catch (Exception ex) {
                System.out.println("delete alarm[0] failed");
                ex.printStackTrace();
            }
            System.out.println("starting kill");
            this.kill();
            System.out.println("kill successful");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AlarmValue createAlarmTemplate() {
        OOSSAlarmValue templateAlarm = new OOSSAlarmValue();
        OOSSAlarmKey ak = new OOSSAlarmKey();
        templateAlarm.setAckSystemId("alarmTemplate test system");
        templateAlarm.setAckTime(new Date());
        templateAlarm.setAckUserId("alarmTemplate TestUser");
        templateAlarm.setAlarmAckState(2);
        templateAlarm.setAdditionalText("alarmTemplatetest additonal text");
        templateAlarm.setAlarmChangedTime(new Date());
        templateAlarm.setAlarmClearedTime(new Date());
        templateAlarm.setAlarmRaisedTime(new Date());
        templateAlarm.setAlarmType("EquipmentAlarm");
        templateAlarm.setManagedObjectClass("alarmTemplate managed object class - testobject");
        templateAlarm.setManagedObjectInstance("alarmTemplate instance1");
        templateAlarm.setPerceivedSeverity((short)2);
        templateAlarm.setProbableCause((short)-1);
        templateAlarm.setSpecificProblem("alarmTemplate specific problem");
        templateAlarm.setProposedRepairActions("alarmTemplate proposed repair actions");
        templateAlarm.setSystemDN("org.openoss");
        ak = new OOSSAlarmKey(Integer.toString(100));
        this.env.setProperty("java.naming.provider.url", "templateAlarm java.naming.provider.url");
        this.env.setProperty("java.naming.factory.initial", "jnp://jbossjmsserver1:1099");
        this.env.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming");
        OOSSApplicationContext ac = new OOSSApplicationContext();
        ac.setURL("templateAlarm.setURL: org.openoss.opennms.qosd.naming.provider");
        ac.setSystemProperties((Map)this.env);
        ac.setFactoryClass("FactoryClassNotSet");
        ak.setApplicationContext((ApplicationContext)ac);
        ak.setType("test-type");
        ak.setApplicationDN("org.openoss");
        templateAlarm.setAlarmKey((AlarmKey)ak);
        return templateAlarm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() throws Exception {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        this.props.put("java.naming.provider.url", "jnp://jbossjmsserver1:1099");
        this.props.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        this.props.put("java.naming.factory.url.pkgs", "org.jboss.naming");
        InitialContext ic = new InitialContext(this.props);
        try {
            this.ref = ic.lookup("System/OpenOSS/ApplicationType/AlarmMonitor/Application/1-0;0-0;OpenNMS_OpenOSS_AM/Comp/JVTHome");
            this.home = (JVTAlarmMonitorHome)PortableRemoteObject.narrow((Object)this.ref, JVTAlarmMonitorHome.class);
            this.session = this.home.create();
        }
        finally {
            ic.close();
        }
        this.alarmInternals = (AlarmMonitor)PortableRemoteObject.narrow((Object)this.session.getHandle().getEJBObject(), AlarmMonitor.class);
        this.am = (AlarmMonitor)PortableRemoteObject.narrow((Object)this.session, AlarmMonitor.class);
    }

    void kill() throws Exception {
        this.session.remove();
        this.alarmInternals = null;
    }
}

