/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.fm.monitor.spring;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.xmlbeans.XmlObject;

public class OssBeanJMSMessageHolder {
    private String handshakeInstance = null;
    private String messageBodyTxt;
    private XmlObject messageBodyXmlObject;
    private Serializable messageBodyJvtObject;
    private Properties ossjMessageProperties = new Properties();
    public static final String OSS_MESSAGE_TYPE = "OSS_MESSAGE_TYPE";
    public static final String OSS_MESSAGE_NAME = "OSS_MESSAGE_NAME";
    public static final String OSS_APPLICATION_TYPE = "OSS_APPLICATION_TYPE";
    public static final String OSS_REQUEST_SENDER_ID = "OSS_REQUEST_SENDER_ID";
    public static final String OSS_REPLYTO_DESTINATION_TYPE = "OSS_REPLYTO_DESTINATION_TYPE";
    public static final String OSS_REPLY_SENDER_ID = "OSS_REPLY_SENDER_ID";
    private String JMSMessageID;
    private String JMSCorrelationID;
    private Destination JMSReplyTo;

    OssBeanJMSMessageHolder() {
    }

    OssBeanJMSMessageHolder(Message msg) {
        this.populateFromMessage(msg);
    }

    OssBeanJMSMessageHolder(ObjectMessage objmsg) {
        this.populateFromMessage(objmsg);
    }

    OssBeanJMSMessageHolder(TextMessage txtmsg) {
        this.populateFromMessage(txtmsg);
    }

    public void populateFromMessage(ObjectMessage objmsg) {
        this.populateFromMessage((Message)objmsg);
        try {
            this.setMessageBodyJvtObject(objmsg.getObject());
        }
        catch (JMSException jmsex) {
            throw new IllegalArgumentException("Error constructing OssBeanJMSMessageHolder from ObjectMessage :", jmsex);
        }
    }

    public void populateFromMessage(TextMessage txtmsg) {
        this.populateFromMessage((Message)txtmsg);
        try {
            this.setMessageBodyTxt(txtmsg.getText());
        }
        catch (JMSException jmsex) {
            throw new IllegalArgumentException("Error constructing OssBeanJMSMessageHolder from TextMessage :", jmsex);
        }
    }

    public void populateFromMessage(Message msg) {
        try {
            this.setJMSCorrelationID(msg.getJMSCorrelationID());
            this.setJMSMessageID(msg.getJMSMessageID());
            this.setJMSReplyTo(msg.getJMSReplyTo());
            this.handshakeInstance = "";
            Destination replyto = msg.getJMSReplyTo();
            if (replyto instanceof Topic) {
                this.handshakeInstance = "Topic:" + ((Topic)replyto).getTopicName();
            }
            if (replyto instanceof Queue) {
                this.handshakeInstance = "Queue:" + ((Queue)replyto).getQueueName();
            }
            this.handshakeInstance = msg.getJMSCorrelationID() != null ? this.handshakeInstance + ":JMSCorrelationID:" + msg.getJMSCorrelationID() : this.handshakeInstance + ":JMSMessageID:" + msg.getJMSMessageID();
        }
        catch (JMSException jmsex) {
            throw new IllegalArgumentException("populateFromMessage() Error populating OssBeanJMSMessageHolder from Message :", jmsex);
        }
        try {
            Enumeration props = msg.getPropertyNames();
            while (props.hasMoreElements()) {
                String key = (String)props.nextElement();
                this.ossjMessageProperties.put(key, msg.getStringProperty(key));
            }
        }
        catch (JMSException jmsex) {
            throw new IllegalArgumentException("populateFromMessage() Error populating OssBeanJMSMessageHolder from Message :", jmsex);
        }
    }

    public String getHandshakeInstance() {
        return this.handshakeInstance;
    }

    public String getMessageBodyTxt() {
        return this.messageBodyTxt;
    }

    public void setMessageBodyTxt(String msgBodyTxt) {
        this.messageBodyTxt = msgBodyTxt;
    }

    public XmlObject getMessageBodyXmlObject() {
        return this.messageBodyXmlObject;
    }

    public void setMessageBodyXmlObject(XmlObject msgBodyXmlObject) {
        this.messageBodyXmlObject = msgBodyXmlObject;
    }

    public Serializable getMessageBodyJvtObject() {
        return this.messageBodyJvtObject;
    }

    public void setMessageBodyJvtObject(Serializable msgBodyJvtObject) {
        this.messageBodyJvtObject = msgBodyJvtObject;
    }

    public Properties getOssjMessageProperties() {
        return this.ossjMessageProperties;
    }

    public void setOssjMessageProperties(Properties ossjMsgProperties) {
        this.ossjMessageProperties = ossjMsgProperties;
    }

    public void setOSS_MESSAGE_TYPE_REQUEST() {
        this.ossjMessageProperties.put(OSS_MESSAGE_TYPE, "REQUEST");
    }

    public void setOSS_MESSAGE_TYPE_RESPONSE() {
        this.ossjMessageProperties.put(OSS_MESSAGE_TYPE, "RESPONSE");
    }

    public void setOSS_MESSAGE_TYPE_EXCEPTION() {
        this.ossjMessageProperties.put(OSS_MESSAGE_TYPE, "EXCEPTION");
    }

    public void setOSS_MESSAGE_NAME(String name) {
        this.ossjMessageProperties.put(OSS_MESSAGE_NAME, name);
    }

    public void setOSS_APPLICATION_TYPE(String name) {
        this.ossjMessageProperties.put(OSS_APPLICATION_TYPE, name);
    }

    public void setOSS_REQUEST_SENDER_ID(String name) {
        this.ossjMessageProperties.put(OSS_REQUEST_SENDER_ID, name);
    }

    public void setOSS_REPLYTO_DESTINATION_TYPE_QUEUE() {
        this.ossjMessageProperties.put(OSS_REPLYTO_DESTINATION_TYPE, "QUEUE");
    }

    public void setOSS_REPLYTO_DESTINATION_TYPE_TOPIC() {
        this.ossjMessageProperties.put(OSS_REPLYTO_DESTINATION_TYPE, "TOPIC");
    }

    public void setOSS_REPLY_SENDER_ID(String name) {
        this.ossjMessageProperties.put(OSS_REPLY_SENDER_ID, name);
    }

    public String getOSS_MESSAGE_TYPE() {
        return (String)this.ossjMessageProperties.get(OSS_MESSAGE_TYPE);
    }

    public String getOSS_MESSAGE_NAME() {
        return (String)this.ossjMessageProperties.get(OSS_MESSAGE_NAME);
    }

    public String getOSS_APPLICATION_TYPE() {
        return (String)this.ossjMessageProperties.get(OSS_APPLICATION_TYPE);
    }

    public String getOSS_REQUEST_SENDER_ID() {
        return (String)this.ossjMessageProperties.get(OSS_REQUEST_SENDER_ID);
    }

    public String getOSS_REPLYTO_DESTINATION_TYPE() {
        return (String)this.ossjMessageProperties.get(OSS_REPLYTO_DESTINATION_TYPE);
    }

    public String getOSS_REPLY_SENDER_ID() {
        return (String)this.ossjMessageProperties.get(OSS_REPLY_SENDER_ID);
    }

    public String getJMSMessageID() {
        return this.JMSMessageID;
    }

    public void setJMSMessageID(String messageID) {
        this.JMSMessageID = messageID;
    }

    public String getJMSCorrelationID() {
        return this.JMSCorrelationID;
    }

    public void setJMSCorrelationID(String correlationID) {
        this.JMSCorrelationID = correlationID;
    }

    public Destination getJMSReplyTo() {
        return this.JMSReplyTo;
    }

    public void setJMSReplyTo(Destination replyTo) {
        this.JMSReplyTo = replyTo;
    }

    public String toString() {
        String s = this.getClass().getSimpleName() + "Message Contents:\n" + "\n\t getJMSMessageID(): " + this.getJMSMessageID() + "\n\t getJMSCorrelationID(): " + this.getJMSCorrelationID() + "\n\t Destination getJMSReplyTo(): " + this.getJMSReplyTo() + "\n\t getHandshakeInstance(): " + this.getHandshakeInstance() + "\n\t getOSS_MESSAGE_TYPE(): " + this.getOSS_MESSAGE_TYPE() + "\n\t getOSS_MESSAGE_NAME(): " + this.getOSS_MESSAGE_NAME() + "\n\t getOSS_APPLICATION_TYPE(): " + this.getOSS_APPLICATION_TYPE() + "\n\t getOSS_REQUEST_SENDER_ID(): " + this.getOSS_REQUEST_SENDER_ID() + "\n\t getOSS_REPLYTO_DESTINATION_TYPE(): " + this.getOSS_REPLYTO_DESTINATION_TYPE() + "\n\t getOSS_REPLY_SENDER_ID(): " + this.getOSS_REPLY_SENDER_ID() + "\n\t getMessageBodyTxt(): " + this.getMessageBodyTxt() + "\n\t getMessageBodyXmlObject(): " + this.getMessageBodyXmlObject() + "\n\t getMessageBodyJvtObject(): " + this.getMessageBodyJvtObject();
        return s;
    }

    public ObjectMessage populateObjectMessage(ObjectMessage msg) {
        msg = (ObjectMessage)this.populateMessage((Message)msg);
        try {
            if (this.messageBodyJvtObject != null) {
                msg.setObject(this.messageBodyJvtObject);
            }
        }
        catch (JMSException jmsex) {
            throw new IllegalArgumentException("populateObjectMessage() Error populating Message Object from OssBeanJMSMessageHolder :", jmsex);
        }
        return msg;
    }

    public TextMessage populateTextMessage(TextMessage msg) {
        msg = (TextMessage)this.populateMessage((Message)msg);
        try {
            if (this.messageBodyXmlObject != null) {
                msg.setText(this.messageBodyXmlObject.toString());
            } else if (this.messageBodyTxt != null) {
                msg.setText(this.messageBodyTxt);
            }
        }
        catch (JMSException jmsex) {
            throw new IllegalArgumentException("populateTextMessage() Error populating Message Text from OssBeanJMSMessageHolder :", jmsex);
        }
        return msg;
    }

    public Message populateMessage(Message msg) {
        try {
            if (this.getJMSCorrelationID() != null) {
                msg.setJMSCorrelationID(this.getJMSCorrelationID());
            }
            if (this.getJMSMessageID() != null) {
                msg.setJMSMessageID(this.getJMSMessageID());
            }
            if (this.getJMSReplyTo() != null) {
                msg.setJMSReplyTo(this.getJMSReplyTo());
            }
        }
        catch (JMSException jmsex) {
            throw new IllegalArgumentException("populateMessage() Error populating Message Properties from OssBeanJMSMessageHolder :", jmsex);
        }
        try {
            Enumeration<Object> props = this.ossjMessageProperties.keys();
            while (props.hasMoreElements()) {
                String key = (String)props.nextElement();
                msg.setStringProperty(key, this.ossjMessageProperties.getProperty(key));
            }
        }
        catch (JMSException jmsex) {
            throw new IllegalArgumentException("populateMessage() Error populating OSS Message Properties from OssBeanJMSMessageHolder :", jmsex);
        }
        return msg;
    }
}

