/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.JdoConf;
import org.exolab.castor.jdo.conf.Mapping;
import org.exolab.castor.jdo.conf.TransactionDemarcation;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.DTDResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JDOConfLoader {
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$jdo$engine$JDOConfLoader == null ? (class$org$exolab$castor$jdo$engine$JDOConfLoader = JDOConfLoader.class$("org.exolab.castor.jdo.engine.JDOConfLoader")) : class$org$exolab$castor$jdo$engine$JDOConfLoader);
    private static boolean _loaded = false;
    private static JdoConf _jdoConf = null;
    static /* synthetic */ Class class$org$exolab$castor$jdo$engine$JDOConfLoader;
    static /* synthetic */ Class class$org$exolab$castor$jdo$conf$JdoConf;

    public static synchronized void loadConfiguration(InputSource source, EntityResolver resolver) throws MappingException {
        if (!_loaded) {
            Unmarshaller unmarshaller = new Unmarshaller(class$org$exolab$castor$jdo$conf$JdoConf == null ? (class$org$exolab$castor$jdo$conf$JdoConf = JDOConfLoader.class$("org.exolab.castor.jdo.conf.JdoConf")) : class$org$exolab$castor$jdo$conf$JdoConf);
            try {
                if (resolver == null) {
                    unmarshaller.setEntityResolver(new DTDResolver());
                } else {
                    unmarshaller.setEntityResolver(new DTDResolver(resolver));
                }
                _jdoConf = (JdoConf)unmarshaller.unmarshal(source);
            }
            catch (MarshalException e) {
                throw new MappingException(e);
            }
            catch (ValidationException e) {
                throw new MappingException(e);
            }
            _loaded = true;
            _log.debug((Object)"Loaded jdo conf successfully");
        }
    }

    public static synchronized void loadConfiguration(JdoConf jdoConf) {
        if (!_loaded) {
            _jdoConf = jdoConf;
            _loaded = true;
            _log.debug((Object)"Loaded jdo conf successfully");
        }
    }

    public static Database[] getDatabases(JdoConf jdoConf) {
        JDOConfLoader.loadConfiguration(jdoConf);
        return _jdoConf.getDatabase();
    }

    public static Database[] getDatabases(InputSource source, EntityResolver resolver) throws MappingException {
        JDOConfLoader.loadConfiguration(source, resolver);
        return _jdoConf.getDatabase();
    }

    public static Database getDatabase(String databaseName, InputSource source, EntityResolver resolver) throws MappingException {
        Database database = null;
        JDOConfLoader.loadConfiguration(source, resolver);
        Database[] databases = JDOConfLoader.getDatabases(source, resolver);
        for (int i = 0; i < databases.length; ++i) {
            if (!databases[i].getName().equals(databaseName)) continue;
            database = databases[i];
        }
        return database;
    }

    public static TransactionDemarcation getTransactionDemarcation(InputSource source, EntityResolver resolver) throws MappingException {
        JDOConfLoader.loadConfiguration(source, resolver);
        return _jdoConf.getTransactionDemarcation();
    }

    public static Mapping[] getMapping(String databaseName, InputSource source, EntityResolver resolver) throws MappingException {
        JDOConfLoader.loadConfiguration(source, resolver);
        return JDOConfLoader.getDatabase(databaseName, source, resolver).getMapping();
    }

    public static synchronized void deleteConfiguration() {
        _loaded = false;
    }

    public static synchronized boolean isLoaded() {
        return _loaded;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

