/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public final class IdentityKeyGenerator
implements KeyGenerator {
    private static Log _log = LogFactory.getFactory().getInstance(class$org$exolab$castor$jdo$drivers$IdentityKeyGenerator == null ? (class$org$exolab$castor$jdo$drivers$IdentityKeyGenerator = IdentityKeyGenerator.class$("org.exolab.castor.jdo.drivers.IdentityKeyGenerator")) : class$org$exolab$castor$jdo$drivers$IdentityKeyGenerator);
    private DefaultIdentityValue identityValue = null;
    private AbstractType type = null;
    static /* synthetic */ Class class$org$exolab$castor$jdo$drivers$IdentityKeyGenerator;

    public IdentityKeyGenerator(PersistenceFactory factory, int sqlType) throws MappingException {
        String fName = factory.getFactoryName();
        if (!(fName.equals("sybase") || fName.equals("sql-server") || fName.equals("hsql") || fName.equals("mysql") || fName.equals("informix") || fName.equals("sapdb") || fName.equals("db2"))) {
            throw new MappingException(Messages.format("mapping.keyGenNotCompatible", this.getClass().getName(), fName));
        }
        if (sqlType != 4 && sqlType != 2 && sqlType != 3 && sqlType != -5) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
        if (sqlType != 4 && fName.equals("hsql")) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
        this.initIdentityValue(sqlType);
        this.initType(fName);
    }

    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        try {
            return this.type.getValue(conn, tableName);
        }
        catch (Exception e) {
            _log.error((Object)"Problem generating new key", (Throwable)e);
            return null;
        }
    }

    public final byte getStyle() {
        return 1;
    }

    private void initIdentityValue(int sqlType) {
        this.identityValue = sqlType == 4 ? new IntegerIdenityValue() : (sqlType == -5 ? new LongIdenityValue() : new DefaultIdentityValue());
    }

    private void initType(String fName) {
        this.type = fName.equals("hsql") ? new HsqlType() : (fName.equals("mysql") ? new MySqlType() : (fName.equals("informix") ? new InformixType() : (fName.equals("db2") ? new DB2Type() : (fName.equals("sapdb") ? new SapDbType() : new DefaultType()))));
    }

    public boolean isInSameConnection() {
        return true;
    }

    public final String patchSQL(String insert, String primKeyName) throws MappingException {
        return insert;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LongIdenityValue
    extends DefaultIdentityValue {
        private LongIdenityValue() {
        }

        Object getValue(int value) {
            return new Long(value);
        }
    }

    private class IntegerIdenityValue
    extends DefaultIdentityValue {
        private IntegerIdenityValue() {
        }

        Object getValue(int value) {
            return new Integer(value);
        }
    }

    private class DefaultIdentityValue {
        private DefaultIdentityValue() {
        }

        Object getValue(int value) {
            return new BigDecimal((double)value);
        }
    }

    private class SapDbType
    extends AbstractType {
        private SapDbType() {
        }

        Object getValue(Connection conn, String tableName) throws PersistenceException {
            return this.getValue("SELECT " + tableName + ".currval" + " FROM " + tableName, conn);
        }
    }

    private class MySqlType
    extends AbstractType {
        private MySqlType() {
        }

        Object getValue(Connection conn, String tableName) throws PersistenceException {
            return this.getValue("SELECT LAST_INSERT_ID()", conn);
        }
    }

    private class InformixType
    extends AbstractType {
        private InformixType() {
        }

        Object getValue(Connection conn, String tableName) throws PersistenceException {
            return this.getValue("select dbinfo('sqlca.sqlerrd1') from systables where tabid = 1", conn);
        }
    }

    private class HsqlType
    extends AbstractType {
        private HsqlType() {
        }

        /*
         * Loose catch block
         */
        Object getValue(Connection conn, String tableName) throws PersistenceException {
            Object v;
            block8: {
                CallableStatement stmt = null;
                v = null;
                stmt = conn.prepareCall("{call IDENTITY()}");
                v = this.getValue(stmt);
                Object var7_5 = null;
                if (stmt == null) break block8;
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    _log.warn((Object)"Problem closing JDBCstatement", (Throwable)ex);
                }
                stmt = null;
                {
                    break block8;
                    catch (SQLException e) {
                        throw new PersistenceException(Messages.format("persist.keyGenSQL", e.toString()));
                    }
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException ex) {
                            _log.warn((Object)"Problem closing JDBCstatement", (Throwable)ex);
                        }
                        stmt = null;
                    }
                    throw throwable;
                }
            }
            return v;
        }
    }

    private class DefaultType
    extends AbstractType {
        private DefaultType() {
        }

        Object getValue(Connection conn, String tableName) throws PersistenceException {
            return this.getValue("SELECT @@identity", conn);
        }
    }

    private class DB2Type
    extends AbstractType {
        private DB2Type() {
        }

        Object getValue(Connection conn, String tableName) throws PersistenceException {
            StringBuffer buf = new StringBuffer("SELECT IDENTITY_VAL_LOCAL() FROM ");
            buf.append(tableName).append(" FETCH FIRST ROW ONLY");
            return this.getValue(buf.toString(), conn);
        }
    }

    private abstract class AbstractType {
        private AbstractType() {
        }

        abstract Object getValue(Connection var1, String var2) throws PersistenceException;

        Object getValue(PreparedStatement stmt) throws PersistenceException, SQLException {
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                return IdentityKeyGenerator.this.identityValue.getValue(rs.getInt(1));
            }
            throw new PersistenceException(Messages.message("persist.keyGenFailed"));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        Object getValue(String sql, Connection conn) throws PersistenceException {
            Object object;
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = conn.prepareStatement(sql);
                    object = this.getValue(stmt);
                    Object var6_6 = null;
                    if (stmt == null) return object;
                }
                catch (SQLException e) {
                    throw new PersistenceException(Messages.format("persist.keyGenSQL", e.toString()));
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (stmt == null) throw throwable;
                try {
                    stmt.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                    throw throwable;
                }
            }
            try {}
            catch (SQLException ex) {
                ex.printStackTrace();
                return object;
            }
            stmt.close();
            return object;
        }
    }
}

