/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.Config;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTransactionResponse;

class BufferCache {
    private static final int MAX_BUFFERS = Config.getInt("jcifs.smb.maxBuffers", 16);
    static Object[] cache = new Object[MAX_BUFFERS];
    private static int numBuffers = 0;
    private static int freeBuffers = 0;

    BufferCache() {
    }

    private static byte[] getBuffer() {
        if (freeBuffers > 0) {
            for (int i = 0; i < MAX_BUFFERS; ++i) {
                if (cache[i] == null) continue;
                byte[] buf = (byte[])cache[i];
                BufferCache.cache[i] = null;
                --freeBuffers;
                return buf;
            }
        }
        byte[] buf = new byte[65535];
        ++numBuffers;
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getBuffers(SmbComTransaction req, SmbComTransactionResponse rsp) {
        Object[] objectArray = cache;
        synchronized (cache) {
            try {
                while (freeBuffers + (MAX_BUFFERS - numBuffers) < 2) {
                    cache.wait();
                }
                req.txn_buf = BufferCache.getBuffer();
                rsp.txn_buf = BufferCache.getBuffer();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseBuffer(byte[] buf) {
        Object[] objectArray = cache;
        synchronized (cache) {
            for (int i = 0; i < MAX_BUFFERS; ++i) {
                if (cache[i] != null) continue;
                BufferCache.cache[i] = buf;
                ++freeBuffers;
                cache.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

