/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Iterator;
import org.drools.RuleBaseConfiguration;
import org.drools.common.AgendaGroupImpl;
import org.drools.common.AgendaItem;
import org.drools.common.InternalAgenda;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.ScheduledAgendaItem;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;
import org.drools.spi.Duration;
import org.drools.spi.PropagationContext;

final class TerminalNode
extends BaseNode
implements TupleSink,
NodeMemory {
    private static final long serialVersionUID = -4172639826881353001L;
    private final Rule rule;
    private final TupleSource tupleSource;

    TerminalNode(int n, TupleSource tupleSource, Rule rule) {
        super(n);
        this.rule = rule;
        this.tupleSource = tupleSource;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void assertTuple(ReteTuple reteTuple, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        this.assertTuple(reteTuple, propagationContext, reteooWorkingMemory, true);
    }

    public void assertTuple(ReteTuple reteTuple, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory, boolean bl) {
        if (this.rule.getNoLoop() && this.rule.equals(propagationContext.getRuleOrigin())) {
            return;
        }
        InternalAgenda internalAgenda = (InternalAgenda)reteooWorkingMemory.getAgenda();
        Duration duration = this.rule.getDuration();
        if (duration != null && duration.getDuration(reteTuple) > 0L) {
            ScheduledAgendaItem scheduledAgendaItem = new ScheduledAgendaItem(propagationContext.getPropagationNumber(), reteTuple, internalAgenda, propagationContext, this.rule);
            if (this.rule.getActivationGroup() != null) {
                TerminalNodeMemory terminalNodeMemory = (TerminalNodeMemory)reteooWorkingMemory.getNodeMemory(this);
                if (terminalNodeMemory.getActivationGroup() == null) {
                    terminalNodeMemory.setActivationGroup(reteooWorkingMemory.getAgenda().getActivationGroup(this.rule.getActivationGroup()));
                }
                terminalNodeMemory.getActivationGroup().addActivation(scheduledAgendaItem);
            }
            internalAgenda.scheduleItem(scheduledAgendaItem);
            reteTuple.setActivation(scheduledAgendaItem);
            scheduledAgendaItem.setActivated(true);
            reteooWorkingMemory.getAgendaEventSupport().fireActivationCreated(scheduledAgendaItem);
        } else {
            TerminalNodeMemory terminalNodeMemory = (TerminalNodeMemory)reteooWorkingMemory.getNodeMemory(this);
            AgendaGroupImpl agendaGroupImpl = terminalNodeMemory.getAgendaGroup();
            if (agendaGroupImpl == null) {
                agendaGroupImpl = this.rule.getAgendaGroup() == null || this.rule.getAgendaGroup().equals("") || this.rule.getAgendaGroup().equals("MAIN") ? (AgendaGroupImpl)internalAgenda.getAgendaGroup("MAIN") : (AgendaGroupImpl)internalAgenda.getAgendaGroup(this.rule.getAgendaGroup());
                if (agendaGroupImpl == null) {
                    agendaGroupImpl = new AgendaGroupImpl(this.rule.getAgendaGroup());
                    internalAgenda.addAgendaGroup(agendaGroupImpl);
                }
                terminalNodeMemory.setAgendaGroup(agendaGroupImpl);
            }
            if (this.rule.getAutoFocus()) {
                internalAgenda.setFocus(agendaGroupImpl);
            }
            AgendaItem agendaItem = new AgendaItem(propagationContext.getPropagationNumber(), reteTuple, propagationContext, this.rule);
            if (this.rule.getActivationGroup() != null) {
                if (terminalNodeMemory.getActivationGroup() == null) {
                    terminalNodeMemory.setActivationGroup(reteooWorkingMemory.getAgenda().getActivationGroup(this.rule.getActivationGroup()));
                }
                terminalNodeMemory.getActivationGroup().addActivation(agendaItem);
            }
            agendaGroupImpl.add(agendaItem);
            reteTuple.setActivation(agendaItem);
            agendaItem.setActivated(true);
            if (bl) {
                reteooWorkingMemory.getAgendaEventSupport().fireActivationCreated(agendaItem);
            }
        }
    }

    public void retractTuple(ReteTuple reteTuple, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        Activation activation = reteTuple.getActivation();
        if (activation != null) {
            if (activation.isActivated()) {
                activation.remove();
                reteooWorkingMemory.getAgendaEventSupport().fireActivationCancelled(activation);
            }
            reteooWorkingMemory.getTruthMaintenanceSystem().removeLogicalDependencies(activation, propagationContext, this.rule);
        }
    }

    public void modifyTuple(ReteTuple reteTuple, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        boolean bl = true;
        Activation activation = reteTuple.getActivation();
        if (activation != null && activation.isActivated()) {
            activation.remove();
            bl = false;
        }
        this.assertTuple(reteTuple, propagationContext, reteooWorkingMemory, bl);
    }

    public String toString() {
        return "[TerminalNode: rule=" + this.rule.getName() + "]";
    }

    public void ruleAttached() {
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(ReteooWorkingMemory[] reteooWorkingMemoryArray) {
        this.attach();
        int n = reteooWorkingMemoryArray.length;
        for (int i = 0; i < n; ++i) {
            ReteooWorkingMemory reteooWorkingMemory = reteooWorkingMemoryArray[i];
            PropagationContextImpl propagationContextImpl = new PropagationContextImpl(reteooWorkingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.tupleSource.updateNewNode(reteooWorkingMemory, propagationContextImpl);
        }
    }

    public void remove(BaseNode baseNode, ReteooWorkingMemory[] reteooWorkingMemoryArray) {
        int n = reteooWorkingMemoryArray.length;
        for (int i = 0; i < n; ++i) {
            ReteooWorkingMemory reteooWorkingMemory = reteooWorkingMemoryArray[i];
            Iterator iterator = this.tupleSource.getPropagatedTuples(reteooWorkingMemory, this).iterator();
            while (iterator.hasNext()) {
                ReteTuple reteTuple = (ReteTuple)iterator.next();
                Activation activation = reteTuple.getActivation();
                if (activation.isActivated()) {
                    activation.remove();
                    reteooWorkingMemory.getAgendaEventSupport().fireActivationCancelled(activation);
                }
                PropagationContextImpl propagationContextImpl = new PropagationContextImpl(reteooWorkingMemory.getNextPropagationIdCounter(), 4, null, null);
                reteooWorkingMemory.getTruthMaintenanceSystem().removeLogicalDependencies(activation, propagationContextImpl, this.rule);
            }
            reteooWorkingMemory.propagateQueuedActions();
        }
        this.removeShare();
        this.tupleSource.remove(this, reteooWorkingMemoryArray);
    }

    public void updateNewNode(ReteooWorkingMemory reteooWorkingMemory, PropagationContext propagationContext) {
    }

    public Object createMemory(RuleBaseConfiguration ruleBaseConfiguration) {
        return new TerminalNodeMemory();
    }

    public int hashCode() {
        return this.rule.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != TerminalNode.class) {
            return false;
        }
        TerminalNode terminalNode = (TerminalNode)object;
        return this.rule.equals(terminalNode.rule);
    }

    class TerminalNodeMemory
    implements Serializable {
        private AgendaGroupImpl agendaGroup;
        private ActivationGroup activationGroup;

        TerminalNodeMemory() {
        }

        public AgendaGroupImpl getAgendaGroup() {
            return this.agendaGroup;
        }

        public void setAgendaGroup(AgendaGroupImpl agendaGroupImpl) {
            this.agendaGroup = agendaGroupImpl;
        }

        public ActivationGroup getActivationGroup() {
            return this.activationGroup;
        }

        public void setActivationGroup(ActivationGroup activationGroup) {
            this.activationGroup = activationGroup;
        }
    }
}

