/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.drools.common.DefaultFactHandle;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkList;
import org.drools.reteoo.ObjectSinkListFactory;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.spi.PropagationContext;

abstract class ObjectSource
extends BaseNode
implements Serializable {
    protected ObjectSinkList objectSinks;

    ObjectSource(int n) {
        this(n, null);
    }

    ObjectSource(int n, ObjectSinkList objectSinkList) {
        super(n);
        this.objectSinks = objectSinkList != null ? objectSinkList : ObjectSinkListFactory.newDefaultObjectSinkList();
    }

    protected void addObjectSink(ObjectSink objectSink) {
        if (!this.objectSinks.contains(objectSink)) {
            this.objectSinks.add(objectSink);
        }
    }

    protected void removeObjectSink(ObjectSink objectSink) {
        this.objectSinks.remove(objectSink);
    }

    protected void propagateAssertObject(DefaultFactHandle defaultFactHandle, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        Iterator iterator = this.objectSinks.iterator(reteooWorkingMemory, defaultFactHandle);
        while (iterator.hasNext()) {
            ((ObjectSink)iterator.next()).assertObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
        }
    }

    protected void propagateRetractObject(DefaultFactHandle defaultFactHandle, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        Iterator iterator = this.objectSinks.iterator();
        while (iterator.hasNext()) {
            ((ObjectSink)iterator.next()).retractObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
        }
    }

    protected void propagateModifyObject(DefaultFactHandle defaultFactHandle, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        Iterator iterator = this.objectSinks.iterator();
        while (iterator.hasNext()) {
            ((ObjectSink)iterator.next()).modifyObject(defaultFactHandle, propagationContext, reteooWorkingMemory);
        }
    }

    public ObjectSinkList getObjectSinks() {
        return this.objectSinks;
    }

    public List getObjectSinksAsList() {
        return this.objectSinks.getObjectsAsList();
    }
}

