/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import org.drools.common.InternalFactHandle;
import org.drools.leaps.ColumnConstraints;
import org.drools.leaps.FactTable;
import org.drools.leaps.LeapsFactHandle;
import org.drools.leaps.LeapsRule;
import org.drools.leaps.LeapsTuple;
import org.drools.leaps.LeapsWorkingMemory;
import org.drools.leaps.NoMatchesFoundException;
import org.drools.leaps.Token;
import org.drools.leaps.util.Table;
import org.drools.leaps.util.TableIterator;
import org.drools.rule.EvalCondition;
import org.drools.rule.InvalidRuleException;

final class TokenEvaluator {
    TokenEvaluator() {
    }

    protected static final void evaluate(Token token) throws NoMatchesFoundException, InvalidRuleException {
        LeapsWorkingMemory leapsWorkingMemory = (LeapsWorkingMemory)token.getWorkingMemory();
        LeapsRule leapsRule = token.getCurrentRuleHandle().getLeapsRule();
        int n = leapsRule.getNumberOfColumns();
        int n2 = token.getCurrentRuleHandle().getDominantPosition();
        InternalFactHandle internalFactHandle = token.getDominantFactHandle();
        if (leapsRule.getColumnConstraintsAtPosition(n2).isAllowedAlpha(internalFactHandle, token, leapsWorkingMemory)) {
            int n3;
            Object object;
            int n4;
            Class clazz = leapsRule.getColumnClassObjectTypeAtPosition(n2);
            TableIterator[] tableIteratorArray = new TableIterator[n];
            for (n4 = 0; n4 < n; ++n4) {
                LeapsFactHandle leapsFactHandle;
                if (n4 == n2) {
                    tableIteratorArray[n4] = Table.singleItemIterator(internalFactHandle);
                    continue;
                }
                Class clazz2 = leapsRule.getColumnClassObjectTypeAtPosition(n4);
                object = leapsRule.getColumnConstraintsAtPosition(n4);
                FactTable factTable = leapsWorkingMemory.getFactTable(clazz2);
                LeapsFactHandle leapsFactHandle2 = leapsFactHandle = clazz == clazz2 ? new LeapsFactHandle(internalFactHandle.getRecency() - 1L, new Object()) : (LeapsFactHandle)internalFactHandle;
                tableIteratorArray[n4] = n4 > 0 && ((ColumnConstraints)object).isAlphaPresent() ? factTable.constrainedIteratorFromPositionToTableStart(leapsWorkingMemory, (ColumnConstraints)object, leapsFactHandle, token.isResume() ? (LeapsFactHandle)token.get(n4) : leapsFactHandle) : factTable.iteratorFromPositionToTableStart(leapsFactHandle, token.isResume() ? (LeapsFactHandle)token.get(n4) : leapsFactHandle);
            }
            n4 = 0;
            boolean bl = token.isResume();
            for (n3 = 0; n3 < n; ++n3) {
                object = tableIteratorArray[n3];
                if (object.isEmpty()) {
                    throw new NoMatchesFoundException();
                }
                if (n4 == 0) {
                    if (!bl || !object.hasNext() || object.peekNext().equals(token.get(n3))) continue;
                    bl = false;
                    n4 = 1;
                    continue;
                }
                object.reset();
            }
            n3 = 0;
            boolean bl2 = false;
            int n5 = n - 1;
            while (!bl2) {
                object = tableIteratorArray[n3];
                if (!object.hasNext()) {
                    if (n3 == 0) {
                        bl2 = true;
                        continue;
                    }
                    object.reset();
                    --n3;
                    if (!bl) continue;
                    bl = false;
                    continue;
                }
                LeapsFactHandle leapsFactHandle = (LeapsFactHandle)object.next();
                boolean bl3 = false;
                if (!bl) {
                    bl3 = n3 != 0 || n3 == n2 ? leapsRule.getColumnConstraintsAtPosition(n3).isAllowedBeta(leapsFactHandle, token, leapsWorkingMemory) : leapsRule.getColumnConstraintsAtPosition(n3).isAllowed(leapsFactHandle, token, leapsWorkingMemory);
                }
                if (!bl3 && !bl) continue;
                token.set(n3, leapsFactHandle);
                if (n3 == n5) {
                    if (!bl) {
                        if (!TokenEvaluator.processAfterAllPositiveConstraintOk(token.getTuple(), leapsRule, leapsWorkingMemory)) continue;
                        return;
                    }
                    bl = false;
                    continue;
                }
                ++n3;
            }
        }
        throw new NoMatchesFoundException();
    }

    static final boolean processAfterAllPositiveConstraintOk(LeapsTuple leapsTuple, LeapsRule leapsRule, LeapsWorkingMemory leapsWorkingMemory) {
        if (leapsRule.containsEvalConditions() && !TokenEvaluator.evaluateEvalConditions(leapsRule, leapsTuple, leapsWorkingMemory)) {
            return false;
        }
        if (leapsRule.containsExistsColumns()) {
            TokenEvaluator.evaluateExistsConditions(leapsTuple, leapsRule, leapsWorkingMemory);
        }
        if (leapsRule.containsNotColumns()) {
            TokenEvaluator.evaluateNotConditions(leapsTuple, leapsRule, leapsWorkingMemory);
        }
        Class[] classArray = leapsRule.getExistsNotColumnsClasses();
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            leapsWorkingMemory.getFactTable(classArray[i]).addTuple(leapsTuple);
        }
        if (leapsTuple.isReadyForActivation()) {
            leapsWorkingMemory.assertTuple(leapsTuple);
            return true;
        }
        return false;
    }

    private static final boolean evaluateEvalConditions(LeapsRule leapsRule, LeapsTuple leapsTuple, LeapsWorkingMemory leapsWorkingMemory) {
        EvalCondition[] evalConditionArray = leapsRule.getEvalConditions();
        for (int i = 0; i < evalConditionArray.length; ++i) {
            if (evalConditionArray[i].isAllowed(leapsTuple, leapsWorkingMemory)) continue;
            return false;
        }
        return true;
    }

    static final void evaluateNotConditions(LeapsTuple leapsTuple, LeapsRule leapsRule, LeapsWorkingMemory leapsWorkingMemory) {
        ColumnConstraints[] columnConstraintsArray = leapsRule.getNotColumnConstraints();
        int n = columnConstraintsArray.length;
        for (int i = 0; i < n; ++i) {
            ColumnConstraints columnConstraints = columnConstraintsArray[i];
            TableIterator tableIterator = leapsWorkingMemory.getFactTable(columnConstraints.getClassType()).reverseOrderIterator();
            boolean bl = false;
            while (!bl && tableIterator.hasNext()) {
                LeapsFactHandle leapsFactHandle = (LeapsFactHandle)tableIterator.next();
                if (!columnConstraints.isAllowed(leapsFactHandle, leapsTuple, leapsWorkingMemory)) continue;
                leapsTuple.setBlockingNotFactHandle(leapsFactHandle, i);
                leapsFactHandle.addNotTuple(leapsTuple, i);
                bl = true;
            }
        }
    }

    static final void evaluateNotCondition(LeapsFactHandle leapsFactHandle, int n, LeapsTuple leapsTuple, LeapsWorkingMemory leapsWorkingMemory) {
        LeapsRule leapsRule = leapsTuple.getLeapsRule();
        ColumnConstraints columnConstraints = leapsRule.getNotColumnConstraints()[n];
        TableIterator tableIterator = leapsWorkingMemory.getFactTable(columnConstraints.getClassType()).iteratorFromPositionToTableEnd(leapsFactHandle);
        boolean bl = false;
        while (!bl && tableIterator.hasNext()) {
            LeapsFactHandle leapsFactHandle2 = (LeapsFactHandle)tableIterator.next();
            if (!columnConstraints.isAllowed(leapsFactHandle2, leapsTuple, leapsWorkingMemory)) continue;
            leapsTuple.setBlockingNotFactHandle(leapsFactHandle2, n);
            leapsFactHandle2.addNotTuple(leapsTuple, n);
            bl = true;
        }
    }

    private static final void evaluateExistsConditions(LeapsTuple leapsTuple, LeapsRule leapsRule, LeapsWorkingMemory leapsWorkingMemory) {
        ColumnConstraints[] columnConstraintsArray = leapsRule.getExistsColumnConstraints();
        int n = columnConstraintsArray.length;
        for (int i = 0; i < n; ++i) {
            ColumnConstraints columnConstraints = columnConstraintsArray[i];
            TableIterator tableIterator = leapsWorkingMemory.getFactTable(columnConstraints.getClassType()).reverseOrderIterator();
            boolean bl = false;
            while (!bl && tableIterator.hasNext()) {
                LeapsFactHandle leapsFactHandle = (LeapsFactHandle)tableIterator.next();
                if (!columnConstraints.isAllowed(leapsFactHandle, leapsTuple, leapsWorkingMemory)) continue;
                leapsTuple.setExistsFactHandle(leapsFactHandle, i);
                leapsFactHandle.addExistsTuple(leapsTuple, i);
                bl = true;
            }
        }
    }

    static final void evaluateExistsCondition(LeapsFactHandle leapsFactHandle, int n, LeapsTuple leapsTuple, LeapsWorkingMemory leapsWorkingMemory) {
        LeapsRule leapsRule = leapsTuple.getLeapsRule();
        ColumnConstraints columnConstraints = leapsRule.getExistsColumnConstraints()[n];
        TableIterator tableIterator = leapsWorkingMemory.getFactTable(columnConstraints.getClassType()).iteratorFromPositionToTableEnd(leapsFactHandle);
        boolean bl = false;
        while (!bl && tableIterator.hasNext()) {
            LeapsFactHandle leapsFactHandle2 = (LeapsFactHandle)tableIterator.next();
            if (!columnConstraints.isAllowed(leapsFactHandle2, leapsTuple, leapsWorkingMemory)) continue;
            leapsTuple.setExistsFactHandle(leapsFactHandle2, n);
            leapsFactHandle2.addExistsTuple(leapsTuple, n);
            bl = true;
        }
    }
}

