/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import org.jrobin.core.DsTypes;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

public class DsDef
implements DsTypes {
    public static final String[] DS_TYPES = new String[]{"GAUGE", "COUNTER", "DERIVE", "ABSOLUTE"};
    static final String FORCE_ZEROS_FOR_NANS_SUFFIX = "!";
    private String dsName;
    private String dsType;
    private long heartbeat;
    private double minValue;
    private double maxValue;

    public DsDef(String string, String string2, long l, double d, double d2) throws RrdException {
        this.dsName = string;
        this.dsType = string2;
        this.heartbeat = l;
        this.minValue = d;
        this.maxValue = d2;
        this.validate();
    }

    public String getDsName() {
        return this.dsName;
    }

    public String getDsType() {
        return this.dsType;
    }

    public long getHeartbeat() {
        return this.heartbeat;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    private void validate() throws RrdException {
        if (this.dsName == null) {
            throw new RrdException("Null datasource name specified");
        }
        if (this.dsName.length() == 0) {
            throw new RrdException("Datasource name length equal to zero");
        }
        if (this.dsName.length() > 20) {
            throw new RrdException("Datasource name [" + this.dsName + "] to long (" + this.dsName.length() + " chars found, only " + 20 + " allowed");
        }
        if (!DsDef.isValidDsType(this.dsType)) {
            throw new RrdException("Invalid datasource type specified: " + this.dsType);
        }
        if (this.heartbeat <= 0L) {
            throw new RrdException("Invalid heartbeat, must be positive: " + this.heartbeat);
        }
        if (!Double.isNaN(this.minValue) && !Double.isNaN(this.maxValue) && this.minValue >= this.maxValue) {
            throw new RrdException("Invalid min/max values specified: " + this.minValue + "/" + this.maxValue);
        }
    }

    public static boolean isValidDsType(String string) {
        for (String string2 : DS_TYPES) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public String dump() {
        return "DS:" + this.dsName + ":" + this.dsType + ":" + this.heartbeat + ":" + Util.formatDouble(this.minValue, "U", false) + ":" + Util.formatDouble(this.maxValue, "U", false);
    }

    public boolean equals(Object object) {
        if (object instanceof DsDef) {
            DsDef dsDef = (DsDef)object;
            return this.dsName.equals(dsDef.dsName);
        }
        return false;
    }

    boolean exactlyEqual(DsDef dsDef) {
        return this.dsName.equals(dsDef.dsName) && this.dsType.equals(dsDef.dsType) && this.heartbeat == dsDef.heartbeat && Util.equal(this.minValue, dsDef.minValue) && Util.equal(this.maxValue, dsDef.maxValue);
    }
}

