/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.drools.lang.dsl.template.Template;
import org.drools.lang.dsl.template.TemplateFactory;

public class RegexTemplate {
    private Pattern templatePattern;
    private List holes;
    private String template;

    public static void main(String[] stringArray) {
        RegexTemplate regexTemplate = new RegexTemplate("the date between {before} and {after}");
        regexTemplate.compile();
        String string = regexTemplate.populate("the date between date1 and date2", "dateBetween({before},{after})");
        RegexTemplate.perfRegex(regexTemplate, string);
        regexTemplate = new RegexTemplate("date of '{date}'");
        regexTemplate.compile();
        System.out.println(regexTemplate.populate("date of 'today' and date of 'tomorrow'", "dateOf({date})"));
        RegexTemplate.perfTemplate();
    }

    private static void perfRegex(RegexTemplate regexTemplate, String string) {
        long l = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            regexTemplate.populate("the date between date1 and date2", "dateBetween({before},{after})");
        }
        System.out.println("time for regex " + (System.currentTimeMillis() - l));
        System.out.println(string);
    }

    private static void perfTemplate() {
        TemplateFactory templateFactory = new TemplateFactory();
        Template template = templateFactory.getTemplate("the date between {before} and {after}");
        long l = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            template.expandAll("the date between date1 and date2", "dateBetween({before},{after})");
        }
        System.out.println("time for non " + (System.currentTimeMillis() - l));
    }

    List lex() {
        ChunkLexer chunkLexer = new ChunkLexer();
        List list = chunkLexer.lex(this.template);
        return list;
    }

    public String populate(String string, String string2) {
        Matcher matcher = this.templatePattern.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        String string3 = string2;
        if (matcher.groupCount() != this.holes.size()) {
            throw new IllegalArgumentException("Unable to match up holes in template with source.");
        }
        for (int i = 0; i < matcher.groupCount(); ++i) {
            String string4 = matcher.group(i + 1);
            String string5 = (String)this.holes.get(i);
            string3 = this.replace(string3, string5, string4.trim());
        }
        return string3;
    }

    public void compile() {
        List list = this.lex();
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.startsWith("{")) {
                arrayList.add(string);
                stringBuffer.append("\\b(.*)\\b");
                continue;
            }
            stringBuffer.append(this.replace(string, " ", "\\s"));
        }
        this.holes = arrayList;
        this.templatePattern = Pattern.compile("\\s*" + stringBuffer.toString() + "\\s*");
    }

    public RegexTemplate(String string) {
        this.template = string;
    }

    private String replace(String string, String string2, String string3) {
        return StringUtils.replace((String)string, (String)string2, (String)string3);
    }

    static class ChunkLexer {
        private final List chunks = new ArrayList();
        private StringBuffer buffer = new StringBuffer();

        ChunkLexer() {
        }

        public List lex(String string) {
            char[] cArray = string.toCharArray();
            block4: for (int i = 0; i < cArray.length; ++i) {
                switch (cArray[i]) {
                    case '{': {
                        this.startHole();
                        continue block4;
                    }
                    case '}': {
                        this.endHole();
                        continue block4;
                    }
                    default: {
                        this.buffer.append(cArray[i]);
                    }
                }
            }
            String string2 = this.buffer.toString();
            if (!string2.equals("")) {
                this.addChunk(string2);
            }
            return this.chunks;
        }

        private boolean addChunk(String string) {
            return this.chunks.add(string.trim());
        }

        private void endHole() {
            String string = this.buffer.toString();
            this.chunks.add("{" + string + "}");
            this.buffer = new StringBuffer();
        }

        private void startHole() {
            String string = this.buffer.toString();
            if (!string.equals("")) {
                this.addChunk(string);
            }
            this.buffer = new StringBuffer();
        }
    }
}

