/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw;

import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import samples.preview_new_graphdraw.Coordinates;

public class CoordinateUtil {
    public static double distance(Coordinates a, Coordinates b) {
        return CoordinateUtil.distance(a, b.getX(), b.getY());
    }

    public static double distance(Coordinates a, double x, double y) {
        double xDelta = a.getX() - x;
        double yDelta = a.getY() - y;
        return Math.sqrt(xDelta * xDelta + yDelta * yDelta);
    }

    public static Coordinates midpoint(Coordinates a, Coordinates b) {
        double midX = (a.getX() + b.getX()) / 2.0;
        double midY = (a.getY() + b.getY()) / 2.0;
        Coordinates midpoint = new Coordinates(midX, midY);
        return midpoint;
    }

    public static Coordinates scale(Coordinates a, double x, double y) {
        return new Coordinates(a.getX() * x, a.getY() * y);
    }

    public static Coordinates add(Coordinates a, double x, double y) {
        return new Coordinates(a.getX() + x, a.getY() + y);
    }

    public static double squareDistanceLineToPoint(Coordinates front, Coordinates back, double x, double y) {
        double distance2;
        double x1 = front.getX();
        double y1 = front.getY();
        double x2 = back.getX();
        double y2 = back.getY();
        if (x1 == x2 && y1 == y2) {
            return CoordinateUtil.getSquareDistance(front, x1, x2);
        }
        double b = ((y - y1) * (y2 - y1) + (x - x1) * (x2 - x1)) / ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        if (b <= 0.0) {
            distance2 = (x - x1) * (x - x1) + (y - y1) * (y - y1);
        } else if (b >= 1.0) {
            distance2 = (x - x2) * (x - x2) + (y - y2) * (y - y2);
        } else {
            double x3 = x1 + b * (x2 - x1);
            double y3 = y1 + b * (y2 - y1);
            distance2 = (x - x3) * (x - x3) + (y - y3) * (y - y3);
        }
        return distance2;
    }

    public static double getSquareDistance(Coordinates u, double x, double y) {
        double x1 = u.getX();
        double y1 = u.getY();
        return (x1 - x) * (x1 - x) + (y1 - y) * (y1 - y);
    }

    public static double angleBetween(Coordinates c, double x, double y) {
        double deltaY = c.getY() - y;
        double deltaX = c.getX() - x;
        return Math.atan2(deltaY, deltaX);
    }

    public static Coordinates getClosestIntersection(Coordinates source, Coordinates dest, Rectangle2D bounds) {
        Collection intersections = CoordinateUtil.getIntersections(source, dest, bounds);
        if (intersections.isEmpty()) {
            return null;
        }
        Iterator iter = intersections.iterator();
        Coordinates closest = (Coordinates)iter.next();
        double best = CoordinateUtil.distance(source, closest);
        while (iter.hasNext()) {
            Coordinates c = (Coordinates)iter.next();
            double c_dist = CoordinateUtil.distance(source, c);
            if (!(c_dist < best)) continue;
            best = c_dist;
            closest = c;
        }
        return closest;
    }

    public static Collection getIntersections(Coordinates source, Coordinates dest, Rectangle2D bounds) {
        double x;
        HashSet<Coordinates> intersections = new HashSet<Coordinates>();
        double top = bounds.getMinY();
        double bottom = bounds.getMaxY();
        double left = bounds.getMinX();
        double right = bounds.getMaxX();
        if (source.getX() == dest.getX()) {
            if (source.getX() >= left && source.getX() <= right) {
                intersections.add(new Coordinates(source.getX(), top));
                intersections.add(new Coordinates(source.getX(), bottom));
            }
            return intersections;
        }
        Line l = new Line(source, dest);
        double y = l.getY(left);
        if (y <= bottom && y >= top) {
            intersections.add(new Coordinates(left, y));
        }
        if ((y = l.getY(right)) <= bottom && y >= top) {
            intersections.add(new Coordinates(right, y));
        }
        if ((x = l.getX(top)) <= right && x >= left) {
            intersections.add(new Coordinates(x, top));
        }
        if ((x = l.getX(bottom)) <= right && x >= left) {
            intersections.add(new Coordinates(x, bottom));
        }
        return intersections;
    }

    protected static class Line {
        private double slope;
        private double intercept;

        public Line(Coordinates source, Coordinates dest) {
            if (source.equals(dest)) {
                throw new IllegalArgumentException("source and dest must be distinct locations");
            }
            double delta_x = dest.getX() - source.getX();
            double delta_y = dest.getY() - source.getY();
            this.slope = delta_y / delta_x;
            this.intercept = (dest.getX() * source.getY() - source.getX() * dest.getY()) / delta_x;
        }

        public Line(double slope, double intercept) {
            this.slope = slope;
            this.intercept = intercept;
        }

        public double getY(double x) {
            return this.slope * x + this.intercept;
        }

        public double getX(double y) {
            return (y - this.intercept) / this.slope;
        }
    }
}

