/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.algorithms.transformation.DirectionTransformer;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.io.PajekNetReader;
import edu.uci.ics.jung.utils.GraphUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.JApplet;
import samples.graph.RankingDemo;

public class RankingDemoDriver
extends JApplet {
    public void start() {
        System.out.println("Starting in applet mode.");
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("samples/datasets/smyth.net");
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        PajekNetReader pnr = new PajekNetReader(true);
        try {
            Graph ug = pnr.load((Reader)br, (Graph)new SparseGraph());
            DirectedGraph g = DirectionTransformer.toDirected(ug);
            GraphUtils.copyLabels(StringLabeller.getLabeller(ug, "jung.io.PajekNetReader.LABEL"), StringLabeller.getLabeller(g, "jung.io.PajekNetReader.LABEL"));
            RankingDemo vizApp = new RankingDemo(g);
            this.getContentPane().add(vizApp);
        }
        catch (IOException e) {
            System.out.println("Error in loading graph");
            e.printStackTrace();
        }
        catch (StringLabeller.UniqueLabelException ule) {
            System.out.println("Unexpected duplicate label");
            ule.printStackTrace();
        }
    }
}

