/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformerDecorator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class HyperbolicTransformer
extends MutableTransformerDecorator
implements MutableTransformer {
    protected Ellipse2D ellipse = new Ellipse2D.Float();
    protected float magnification = 0.7f;

    public HyperbolicTransformer(Component component) {
        this(component, new MutableAffineTransformer());
    }

    public HyperbolicTransformer(Component component, MutableTransformer delegate) {
        super(delegate);
        this.setComponent(component);
        component.addComponentListener(new ComponentListenerImpl());
    }

    private void setComponent(Component component) {
        Dimension d = component.getSize();
        if (d.width <= 0 || d.height <= 0) {
            d = component.getPreferredSize();
        }
        float ewidth = (float)d.width / 1.5f;
        float eheight = (float)d.height / 1.5f;
        this.ellipse.setFrame((float)(d.width / 2) - ewidth / 2.0f, (float)(d.height / 2) - eheight / 2.0f, ewidth, eheight);
    }

    public float getMagnification() {
        return this.magnification;
    }

    public void setMagnification(float magnification) {
        this.magnification = magnification;
    }

    public Point2D getViewCenter() {
        return new Point2D.Double(this.ellipse.getCenterX(), this.ellipse.getCenterY());
    }

    public void setViewCenter(Point2D viewCenter) {
        double width = this.ellipse.getWidth();
        double height = this.ellipse.getHeight();
        this.ellipse.setFrame(viewCenter.getX() - width / 2.0, viewCenter.getY() - height / 2.0, width, height);
    }

    public double getViewRadius() {
        return this.ellipse.getHeight() / 2.0;
    }

    public void setViewRadius(double viewRadius) {
        double x = this.ellipse.getCenterX();
        double y = this.ellipse.getCenterY();
        double viewRatio = this.getRatio();
        this.ellipse.setFrame(x - viewRadius / viewRatio, y - viewRadius, 2.0 * viewRadius / viewRatio, 2.0 * viewRadius);
    }

    public double getRatio() {
        return this.ellipse.getHeight() / this.ellipse.getWidth();
    }

    public void setEllipse(Ellipse2D ellipse) {
        this.ellipse = ellipse;
    }

    public Ellipse2D getEllipse() {
        return this.ellipse;
    }

    public void setToIdentity() {
        this.delegate.setToIdentity();
    }

    protected Point2D polarToCartesian(PolarPoint polar) {
        return this.polarToCartesian(polar.getTheta(), polar.getRadius());
    }

    protected Point2D polarToCartesian(double theta, double radius) {
        return new Point2D.Double(radius * Math.cos(theta), radius * Math.sin(theta));
    }

    protected PolarPoint cartesianToPolar(Point2D point) {
        return this.cartesianToPolar(point.getX(), point.getY());
    }

    protected PolarPoint cartesianToPolar(double x, double y) {
        double theta = Math.atan2(y, x);
        double radius = Math.sqrt(x * x + y * y);
        return new PolarPoint(theta, radius);
    }

    public Point2D transform(Point2D graphPoint) {
        if (graphPoint == null) {
            return null;
        }
        Point2D viewCenter = this.getViewCenter();
        double viewRadius = this.getViewRadius();
        double ratio = this.getRatio();
        Point2D viewPoint = this.delegate.transform(graphPoint);
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point2D.Double pointFromCenter = new Point2D.Double(dx *= ratio, dy);
        PolarPoint polar = this.cartesianToPolar(pointFromCenter);
        double theta = polar.getTheta();
        double radius = polar.getRadius();
        if (radius > viewRadius) {
            return viewPoint;
        }
        double mag = Math.tan(1.5707963267948966 * (double)this.magnification);
        radius *= mag;
        radius = Math.min(radius, viewRadius);
        radius /= viewRadius;
        radius *= 1.5707963267948966;
        radius = Math.abs(Math.atan(radius));
        Point2D projectedPoint = this.polarToCartesian(theta, radius *= viewRadius);
        projectedPoint.setLocation(projectedPoint.getX() / ratio, projectedPoint.getY());
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.getX() + viewCenter.getX(), projectedPoint.getY() + viewCenter.getY());
        return translatedBack;
    }

    public Point2D inverseTransform(Point2D viewPoint) {
        Point2D viewCenter = this.getViewCenter();
        double viewRadius = this.getViewRadius();
        double ratio = this.getRatio();
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point2D.Double pointFromCenter = new Point2D.Double(dx *= ratio, dy);
        PolarPoint polar = this.cartesianToPolar(pointFromCenter);
        double radius = polar.getRadius();
        if (radius > viewRadius) {
            return this.delegate.inverseTransform(viewPoint);
        }
        radius /= viewRadius;
        radius = Math.abs(Math.tan(radius));
        radius /= 1.5707963267948966;
        radius *= viewRadius;
        double mag = Math.tan(1.5707963267948966 * (double)this.magnification);
        polar.setRadius(radius /= mag);
        Point2D projectedPoint = this.polarToCartesian(polar);
        projectedPoint.setLocation(projectedPoint.getX() / ratio, projectedPoint.getY());
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.getX() + viewCenter.getX(), projectedPoint.getY() + viewCenter.getY());
        return this.delegate.inverseTransform(translatedBack);
    }

    public double getDistanceFromCenter(Point2D p) {
        double dx = this.ellipse.getCenterX() - p.getX();
        double dy = this.ellipse.getCenterY() - p.getY();
        return Math.sqrt((dx *= this.getRatio()) * dx + dy * dy);
    }

    static class PolarPoint
    extends Point2D.Double {
        public PolarPoint(double theta, double radius) {
            super(theta, radius);
        }

        public double getTheta() {
            return this.getX();
        }

        public double getRadius() {
            return this.getY();
        }

        public void setTheta(double theta) {
            this.setLocation(theta, this.getRadius());
        }

        public void setRadius(double radius) {
            this.setLocation(this.getTheta(), radius);
        }
    }

    protected class ComponentListenerImpl
    extends ComponentAdapter {
        protected ComponentListenerImpl() {
        }

        public void componentResized(ComponentEvent e) {
            HyperbolicTransformer.this.setComponent(e.getComponent());
        }
    }
}

