/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.subLayout;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.LayoutDecorator;
import edu.uci.ics.jung.visualization.subLayout.SubLayout;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class SubLayoutDecorator
extends LayoutDecorator {
    protected final Collection subLayouts = new LinkedHashSet();

    public SubLayoutDecorator(Layout delegate) {
        super(delegate);
    }

    public void addSubLayout(SubLayout subLayout) {
        this.subLayouts.add(subLayout);
        this.fireStateChanged();
    }

    public boolean removeSubLayout(SubLayout subLayout) {
        boolean wasThere = this.subLayouts.remove(subLayout);
        this.fireStateChanged();
        return wasThere;
    }

    public void removeAllSubLayouts() {
        this.subLayouts.clear();
        this.fireStateChanged();
    }

    protected Point2D getLocationInSubLayout(ArchetypeVertex v) {
        SubLayout subLayout;
        Point2D location = null;
        Iterator iterator = this.subLayouts.iterator();
        while (iterator.hasNext() && (location = (subLayout = (SubLayout)iterator.next()).getLocation(v)) == null) {
        }
        return location;
    }

    public Point2D getLocation(ArchetypeVertex v) {
        Point2D p = this.getLocationInSubLayout(v);
        if (p != null) {
            return p;
        }
        return super.getLocation(v);
    }

    public void forceMove(Vertex picked, double x, double y) {
        Point2D p = this.getLocationInSubLayout(picked);
        if (p != null) {
            p.setLocation(x, y);
        } else {
            super.forceMove(picked, x, y);
        }
        this.fireStateChanged();
    }
}

