/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.subLayout;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.subLayout.SubLayout;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class CircularSubLayout
implements SubLayout {
    protected double radius;
    protected Point2D center;
    protected final Map map = new LinkedHashMap();

    public CircularSubLayout(Collection vertices, double radius, Point2D center) {
        this.radius = radius;
        this.center = center;
        this.initializeLocations(vertices);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    private void initializeLocations(Collection vertices) {
        Vertex[] vertexArray = vertices.toArray(new Vertex[vertices.size()]);
        if (this.center == null) {
            this.center = new Point2D.Double(this.radius, this.radius);
        }
        if (vertexArray.length > 1) {
            for (int i = 0; i < vertexArray.length; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)vertexArray.length;
                Point2D.Double point = new Point2D.Double(Math.cos(angle) * this.radius + this.center.getX(), Math.sin(angle) * this.radius + this.center.getY());
                this.map.put(vertexArray[i], point);
            }
        }
    }

    public Point2D getLocation(ArchetypeVertex v) {
        return (Point2D)this.map.get(v);
    }
}

