/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.SatelliteVisualizationViewer;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;

public class SatelliteScalingGraphMousePlugin
extends ScalingGraphMousePlugin {
    public SatelliteScalingGraphMousePlugin() {
    }

    public SatelliteScalingGraphMousePlugin(int modifiers) {
        super(modifiers);
    }

    public SatelliteScalingGraphMousePlugin(float in, float out) {
        super(in, out);
    }

    public SatelliteScalingGraphMousePlugin(int modifiers, float in, float out) {
        super(modifiers, in, out);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        VisualizationViewer vv;
        boolean accepted = this.checkModifiers(e);
        if (accepted && (vv = (VisualizationViewer)e.getSource()) instanceof SatelliteVisualizationViewer) {
            VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
            MutableTransformer modelTransformerMaster = vvMaster.getLayoutTransformer();
            Point2D center = vv.getCenter();
            Point2D ivtcenter = vv.inverseTransform(center);
            int amount = e.getWheelRotation();
            if (amount > 0) {
                modelTransformerMaster.scale(this.in, this.in, ivtcenter);
            } else if (amount < 0) {
                modelTransformerMaster.scale(this.out, this.out, ivtcenter);
            }
            e.consume();
            vv.repaint();
        }
    }
}

