/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import java.util.Comparator;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Vector;

public class MapBinaryHeap {
    private Vector heap;
    private HashMap object_indices;
    private Comparator comp;
    private static final int TOP = 0;

    public MapBinaryHeap(Comparator c) {
        this.initialize(c);
    }

    public MapBinaryHeap() {
        this.initialize(new ComparableComparator());
    }

    private void initialize(Comparator c) {
        this.comp = c;
        this.object_indices = new HashMap();
        this.heap = new Vector();
    }

    public void clear() {
        this.object_indices = new HashMap();
        this.heap = new Vector();
    }

    public void insert(Object o) {
        int i = this.heap.size();
        this.heap.setSize(i + 1);
        this.percolateUp(i, o);
    }

    public boolean isEmpty() {
        return this.heap.isEmpty();
    }

    public Object peek() throws NoSuchElementException {
        return this.heap.elementAt(0);
    }

    public Object pop() throws NoSuchElementException {
        Object top = this.heap.elementAt(0);
        if (top == null) {
            return top;
        }
        Object bottom_elt = this.heap.lastElement();
        this.heap.setElementAt(bottom_elt, 0);
        this.object_indices.put(bottom_elt, new Integer(0));
        this.heap.setSize(this.heap.size() - 1);
        if (this.heap.size() > 1) {
            this.percolateDown(0);
        }
        this.object_indices.remove(top);
        return top;
    }

    public int size() {
        return this.heap.size();
    }

    public void update(Object o) {
        int cur = (Integer)this.object_indices.get(o);
        int new_idx = this.percolateUp(cur, o);
        this.percolateDown(new_idx);
    }

    private void percolateDown(int cur) {
        int left = this.lChild(cur);
        int right = this.rChild(cur);
        int smallest = left < this.heap.size() && this.comp.compare(this.heap.elementAt(left), this.heap.elementAt(cur)) < 0 ? left : cur;
        if (right < this.heap.size() && this.comp.compare(this.heap.elementAt(right), this.heap.elementAt(smallest)) < 0) {
            smallest = right;
        }
        if (cur != smallest) {
            this.swap(cur, smallest);
            this.percolateDown(smallest);
        }
    }

    private int percolateUp(int cur, Object o) {
        int i = cur;
        while (i > 0 && this.comp.compare(this.heap.elementAt(this.parent(i)), o) > 0) {
            Object parentElt = this.heap.elementAt(this.parent(i));
            this.heap.setElementAt(parentElt, i);
            this.object_indices.put(parentElt, new Integer(i));
            i = this.parent(i);
        }
        this.object_indices.put(o, new Integer(i));
        this.heap.setElementAt(o, i);
        return i;
    }

    private int lChild(int i) {
        return (i << 1) + 1;
    }

    private int rChild(int i) {
        return (i << 1) + 2;
    }

    private int parent(int i) {
        return i - 1 >> 1;
    }

    private void swap(int i, int j) {
        Object iElt = this.heap.elementAt(i);
        Object jElt = this.heap.elementAt(j);
        this.heap.setElementAt(jElt, i);
        this.object_indices.put(jElt, new Integer(i));
        this.heap.setElementAt(iElt, j);
        this.object_indices.put(iElt, new Integer(j));
    }

    private class ComparableComparator
    implements Comparator {
        private ComparableComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (!(arg0 instanceof Comparable) || !(arg1 instanceof Comparable)) {
                throw new IllegalArgumentException("Arguments must be Comparable");
            }
            Comparable i1 = (Comparable)arg0;
            Comparable i2 = (Comparable)arg1;
            return i1.compareTo(i2);
        }
    }
}

