/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.AbstractSparseVertex;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class LeanSparseVertex
extends AbstractSparseVertex {
    protected List incident_edges;

    protected void initialize() {
        super.initialize();
        this.incident_edges = new LinkedList();
    }

    protected Collection getNeighbors_internal() {
        HashSet<Vertex> neighbors = new HashSet<Vertex>();
        Iterator inco_it = this.incident_edges.iterator();
        while (inco_it.hasNext()) {
            neighbors.add(((Edge)inco_it.next()).getOpposite(this));
        }
        return neighbors;
    }

    protected Collection getEdges_internal() {
        return this.incident_edges;
    }

    protected void addNeighbor_internal(Edge e, Vertex v) {
        this.incident_edges.add(e);
    }

    protected void removeNeighbor_internal(Edge e, Vertex v) {
        this.incident_edges.remove(e);
    }

    public Set findEdgeSet(Vertex w) {
        HashSet<Edge> edges = new HashSet<Edge>();
        Iterator iter = this.incident_edges.iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            if (!(e instanceof UndirectedEdge) && ((DirectedEdge)e).getDest() != w) continue;
            edges.add(e);
        }
        return edges;
    }

    public Set getPredecessors() {
        HashSet<Vertex> preds = new HashSet<Vertex>();
        Iterator iter = this.incident_edges.iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            if (!(e instanceof UndirectedEdge) && ((DirectedEdge)e).getDest() != this) continue;
            preds.add(e.getOpposite(this));
        }
        return preds;
    }

    public Set getSuccessors() {
        HashSet<Vertex> succs = new HashSet<Vertex>();
        Iterator iter = this.incident_edges.iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            if (!(e instanceof UndirectedEdge) && ((DirectedEdge)e).getSource() != this) continue;
            succs.add(e.getOpposite(this));
        }
        return succs;
    }

    public Set getInEdges() {
        HashSet<Edge> in = new HashSet<Edge>();
        Iterator iter = this.incident_edges.iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            if (!(e instanceof UndirectedEdge) && ((DirectedEdge)e).getDest() != this) continue;
            in.add(e);
        }
        return in;
    }

    public Set getOutEdges() {
        HashSet<Edge> out = new HashSet<Edge>();
        Iterator iter = this.incident_edges.iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            if (!(e instanceof UndirectedEdge) && ((DirectedEdge)e).getSource() != this) continue;
            out.add(e);
        }
        return out;
    }

    public int inDegree() {
        return this.getInEdges().size();
    }

    public int outDegree() {
        return this.getOutEdges().size();
    }

    public int numPredecessors() {
        return this.getPredecessors().size();
    }

    public int numSuccessors() {
        return this.getSuccessors().size();
    }

    public boolean isSuccessorOf(Vertex v) {
        Iterator iter = this.incident_edges.iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            if (e.getOpposite(this) != v) continue;
            if (e instanceof DirectedEdge) {
                return ((DirectedEdge)e).getDest() == this;
            }
            return true;
        }
        return false;
    }

    public boolean isPredecessorOf(Vertex v) {
        Iterator iter = this.incident_edges.iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            if (e.getOpposite(this) != v) continue;
            if (e instanceof DirectedEdge) {
                return ((DirectedEdge)e).getSource() == this;
            }
            return true;
        }
        return false;
    }

    public boolean isSource(Edge e) {
        if (e instanceof DirectedEdge) {
            return ((DirectedEdge)e).getSource() == this;
        }
        return e.isIncident(this);
    }

    public boolean isDest(Edge e) {
        if (e instanceof DirectedEdge) {
            return ((DirectedEdge)e).getDest() == this;
        }
        return e.isIncident(this);
    }
}

