/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.filters.impl;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.filters.Filter;
import edu.uci.ics.jung.graph.filters.UnassembledGraph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class KNeighborhoodFilter
implements Filter {
    public static final int IN_OUT = 0;
    public static final int IN = 1;
    public static final int OUT = 2;
    private Set rootNodes;
    private int radiusK;
    private int edgeType;

    public KNeighborhoodFilter(Set rootNodes, int radiusK, int edgeType) {
        this.rootNodes = rootNodes;
        this.radiusK = radiusK;
        this.edgeType = edgeType;
    }

    public KNeighborhoodFilter(Vertex rootNode, int radiusK, int edgeType) {
        this.rootNodes = new HashSet();
        this.rootNodes.add(rootNode);
        this.radiusK = radiusK;
        this.edgeType = edgeType;
    }

    public String getName() {
        return "KNeighborhood(" + this.radiusK + "," + this.edgeType + ")";
    }

    public UnassembledGraph filter(Graph graph) {
        int currentDepth = 0;
        ArrayList<Vertex> currentVertices = new ArrayList<Vertex>();
        HashSet<Vertex> visitedVertices = new HashSet<Vertex>();
        HashSet<Edge> visitedEdges = new HashSet<Edge>();
        HashSet<Vertex> acceptedVertices = new HashSet<Vertex>();
        Iterator rootIt = this.rootNodes.iterator();
        while (rootIt.hasNext()) {
            Vertex currentRoot = (Vertex)rootIt.next();
            visitedVertices.add(currentRoot);
            acceptedVertices.add(currentRoot);
            currentVertices.add(currentRoot);
        }
        ArrayList<Vertex> newVertices = null;
        while (currentDepth < this.radiusK) {
            newVertices = new ArrayList<Vertex>();
            Iterator vertexIt = currentVertices.iterator();
            while (vertexIt.hasNext()) {
                Vertex currentVertex = (Vertex)vertexIt.next();
                Set edges = null;
                switch (this.edgeType) {
                    case 0: {
                        edges = currentVertex.getIncidentEdges();
                        break;
                    }
                    case 1: {
                        edges = currentVertex.getInEdges();
                        break;
                    }
                    case 2: {
                        edges = currentVertex.getOutEdges();
                    }
                }
                Iterator neighboringEdgeIt = edges.iterator();
                while (neighboringEdgeIt.hasNext()) {
                    Edge currentEdge = (Edge)neighboringEdgeIt.next();
                    Vertex currentNeighbor = currentEdge.getOpposite(currentVertex);
                    if (visitedEdges.contains(currentEdge)) continue;
                    visitedEdges.add(currentEdge);
                    if (visitedVertices.contains(currentNeighbor)) continue;
                    visitedVertices.add(currentNeighbor);
                    acceptedVertices.add(currentNeighbor);
                    newVertices.add(currentNeighbor);
                }
            }
            currentVertices = newVertices;
            ++currentDepth;
        }
        UnassembledGraph ug = new UnassembledGraph((Filter)this, acceptedVertices, graph.getEdges(), graph);
        return ug;
    }
}

