/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.decorators;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashMap;
import java.util.Map;

public class EdgeWeightLabeller
implements NumberEdgeValue {
    public static final Object WEIGHT_DEFAULT_KEY = "WeightDefaultKey";
    private Map edgeToWeight = new HashMap();
    private Graph graph;

    public static EdgeWeightLabeller getLabeller(Graph g) {
        return EdgeWeightLabeller.getLabeller(g, WEIGHT_DEFAULT_KEY);
    }

    public static boolean hasWeightLabeller(Graph g) {
        return EdgeWeightLabeller.hasWeightLabeller(g, WEIGHT_DEFAULT_KEY);
    }

    public static boolean hasWeightLabeller(Graph g, Object key) {
        EdgeWeightLabeller id = (EdgeWeightLabeller)g.getUserDatum(key);
        return id != null;
    }

    public static EdgeWeightLabeller getLabeller(Graph g, Object key) {
        EdgeWeightLabeller id = (EdgeWeightLabeller)g.getUserDatum(key);
        if (id != null) {
            return id;
        }
        id = new EdgeWeightLabeller(g);
        g.addUserDatum(key, id, UserData.REMOVE);
        return id;
    }

    public int getWeight(ArchetypeEdge e) {
        if (!this.edgeToWeight.containsKey(e)) {
            throw new IllegalArgumentException("This edge has no assigned weight");
        }
        return ((Number)this.edgeToWeight.get(e)).intValue();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setWeight(ArchetypeEdge e, int i) {
        if (!this.graph.getEdges().contains(e)) {
            throw new IllegalArgumentException("This edge is not a part of this graph");
        }
        this.edgeToWeight.put(e, new Integer(i));
    }

    private EdgeWeightLabeller(Graph g) {
        this.graph = g;
    }

    public Number getNumber(ArchetypeEdge e) {
        Number value = (Number)this.edgeToWeight.get(e);
        if (value == null) {
            throw new IllegalArgumentException("This edge is unweighted");
        }
        return value;
    }

    public void setNumber(ArchetypeEdge e, Number n) {
        if (!this.graph.getEdges().contains(e)) {
            throw new IllegalArgumentException("This edge is not a part of this graph");
        }
        this.edgeToWeight.put(e, n);
    }
}

