/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeValue;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.NumberVertexValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class VoltageRanker {
    protected NumberEdgeValue edge_weights;
    protected NumberVertexValue voltages;
    protected int max_iterations;
    protected double convergence_threshold;

    public VoltageRanker(NumberEdgeValue edge_weights, NumberVertexValue voltages, int num_iterations, double convergence_threshold) {
        if (num_iterations < 1) {
            throw new IllegalArgumentException("num_iterations must be >= 1");
        }
        if (convergence_threshold < 0.0) {
            throw new IllegalArgumentException("convergence_threshold must be >= 0");
        }
        this.edge_weights = edge_weights;
        this.voltages = voltages;
        this.max_iterations = num_iterations;
        this.convergence_threshold = convergence_threshold;
    }

    public VoltageRanker(NumberVertexValue voltages, int num_iterations, double threshold) {
        this(new ConstantEdgeValue(1.0), voltages, num_iterations, threshold);
    }

    public void calculateVoltages(Graph g, Set sources, Set sinks) {
        if (sources == null || sources.isEmpty() || sinks == null || sinks.isEmpty()) {
            throw new IllegalArgumentException("at least one source and one sink must exist");
        }
        if (sources.size() + sinks.size() > g.numVertices()) {
            throw new IllegalArgumentException("either sources and sinks overlap or sources and sinks contain vertices not in g");
        }
        HashMap unit_sources = new HashMap();
        Iterator iter = sources.iterator();
        while (iter.hasNext()) {
            unit_sources.put(iter.next(), new Double(1.0));
        }
        this.calculateVoltages(g, unit_sources, sinks);
    }

    public void calculateVoltages(Graph g, Map source_voltages, Set sinks) {
        if (source_voltages == null || source_voltages.isEmpty() || sinks == null || sinks.isEmpty()) {
            throw new IllegalArgumentException("at least one source and one sink must exist");
        }
        if (source_voltages.size() + sinks.size() > g.numVertices()) {
            throw new IllegalArgumentException("either sources and sinks overlap or sources and sinks contain vertices not in g");
        }
        Set sources = source_voltages.keySet();
        Indexer id = Indexer.getIndexer(g);
        Set vertices = g.getVertices();
        double[] volt_array = new double[vertices.size()];
        for (int i = 0; i < volt_array.length; ++i) {
            Vertex v = (Vertex)id.getVertex(i);
            if (sources.contains(v)) {
                Number voltage = (Number)source_voltages.get(v);
                volt_array[i] = voltage.doubleValue();
                this.voltages.setNumber(v, voltage);
                continue;
            }
            volt_array[i] = 0.0;
            this.voltages.setNumber(v, new Double(0.0));
        }
        int iteration = 0;
        double max_change = Double.POSITIVE_INFINITY;
        while (iteration++ < this.max_iterations && max_change > this.convergence_threshold) {
            max_change = 0.0;
            Iterator iter = vertices.iterator();
            while (iter.hasNext()) {
                Vertex v = (Vertex)iter.next();
                if (sources.contains(v) || sinks.contains(v)) continue;
                Set edges = v.getInEdges();
                double voltage_sum = 0.0;
                double weight_sum = 0.0;
                Iterator e_iter = edges.iterator();
                while (e_iter.hasNext()) {
                    Edge e = (Edge)e_iter.next();
                    Vertex w = e.getOpposite(v);
                    double weight = this.edge_weights.getNumber(e).doubleValue();
                    voltage_sum += volt_array[id.getIndex(w)] * weight;
                    weight_sum += weight;
                }
                double new_voltage = voltage_sum == 0.0 && weight_sum == 0.0 ? 0.0 : voltage_sum / weight_sum;
                max_change = Math.max(max_change, Math.abs(this.voltages.getNumber(v).doubleValue() - new_voltage));
                this.voltages.setNumber(v, new Double(new_voltage));
            }
            for (int i = 0; i < volt_array.length; ++i) {
                volt_array[i] = this.voltages.getNumber(id.getVertex(i)).doubleValue();
            }
        }
    }

    public void calculateVoltages(Vertex source, Vertex target) {
        HashSet<Vertex> sources = new HashSet<Vertex>();
        HashSet<Vertex> sinks = new HashSet<Vertex>();
        sources.add(source);
        sinks.add(target);
        this.calculateVoltages((Graph)source.getGraph(), sources, sinks);
    }
}

