/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.PageMasterReference;
import org.apache.fop.fo.pagination.PageSequenceMaster;

public class SinglePageMasterReference
extends PageMasterReference {
    private static final int FIRST = 0;
    private static final int DONE = 1;
    private int state;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SinglePageMasterReference(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (this.getProperty("master-reference") != null) {
            this.masterName = this.getProperty("master-reference").getString();
            if (!parent.getName().equals("fo:page-sequence-master")) throw new FOPException("A fo:single-page-master-reference must be child of fo:page-sequence-master, not " + parent.getName(), systemId, line, column);
            PageSequenceMaster pageSequenceMaster = (PageSequenceMaster)parent;
            pageSequenceMaster.addSubsequenceSpecifier(this);
        } else {
            this.log.warn("A fo:single-page-master-reference does not have a master-reference and so is being ignored");
        }
        this.state = 0;
    }

    public String getName() {
        return "fo:single-page-master-reference";
    }

    public String getNextPageMasterName(boolean isOddPage, boolean isFirstPage, boolean isEmptyPage) {
        if (this.state == 0) {
            this.state = 1;
            return this.getMasterName();
        }
        return null;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void reset() {
        this.state = 0;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new SinglePageMasterReference(parent, propertyList, systemId, line, column);
        }
    }
}

