/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.qosd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.RMISecurityManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.oss.fm.monitor.AlarmKey;
import javax.oss.fm.monitor.AlarmValue;
import org.apache.log4j.Logger;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.xml.event.Event;
import org.openoss.opennms.spring.dao.OnmsAlarmOssjMapper;
import org.openoss.opennms.spring.dao.OssDaoOpenNMSImpl;
import org.openoss.opennms.spring.qosd.AlarmListConnectionManager;
import org.openoss.opennms.spring.qosd.OpenNMSEventHandlerThread;
import org.openoss.opennms.spring.qosd.PropertiesLoader;
import org.openoss.opennms.spring.qosd.QoSD;
import org.openoss.opennms.spring.qosd.QoSDConfigFactory;
import org.openoss.opennms.spring.qosd.QoSDConfiguration;
import org.openoss.ossj.jvt.fm.monitor.OOSSAlarmValue;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class QoSDimpl2
implements PausableFiber,
EventListener,
QoSD {
    private static OssDaoOpenNMSImpl ossDao;
    private static OnmsAlarmOssjMapper onmsAlarmOssjMapper;
    private static AssetRecordDao assetRecordDao;
    private static NodeDao nodeDao;
    private static EventIpcManager eventIpcManager;
    private static AlarmDao alarmDao;
    private static AlarmListConnectionManager alarmListConnectionManager;
    private ClassPathXmlApplicationContext m_context = null;
    private int status = 0;
    private QoSDConfiguration config = null;
    public static PropertiesLoader props;
    private static Properties env;
    private static Hashtable<String, String> triggerUeiList;
    public static final String NAME = "OpenOSS.QoSD";
    private static final String LOG4J_CATEGORY = "OpenOSS.QoSD";
    private static String m_stats;
    public static boolean useUeiList;
    OpenNMSEventHandlerThread openNMSEventHandlerThread;

    public static Logger getLog() {
        ThreadCategory.setPrefix((String)"OpenOSS.QoSD");
        return (Logger)ThreadCategory.getInstance(QoSDimpl2.class);
    }

    public void setossDao(OssDaoOpenNMSImpl _ossDao) {
        ossDao = _ossDao;
    }

    public void setOnmsAlarmOssjMapper(OnmsAlarmOssjMapper _onmsAlarmOssjMapper) {
        onmsAlarmOssjMapper = _onmsAlarmOssjMapper;
    }

    public void setassetRecordDao(AssetRecordDao ar) {
        assetRecordDao = ar;
    }

    public void setnodeDao(NodeDao nodedao) {
        nodeDao = nodedao;
    }

    public void seteventIpcManager(EventIpcManager evtIpcManager) {
        eventIpcManager = evtIpcManager;
    }

    public void setalarmDao(AlarmDao almDao) {
        alarmDao = almDao;
    }

    public void setalarmListConnectionManager(AlarmListConnectionManager alcm) {
        alarmListConnectionManager = alcm;
    }

    public void setapplicationcontext(ClassPathXmlApplicationContext m_context) {
        this.m_context = m_context;
    }

    public void init() {
        Logger log = QoSDimpl2.getLog();
        log.info((Object)"Initialising QoSD");
    }

    public void start() {
        String jnp_host;
        this.status = 1;
        Logger log = QoSDimpl2.getLog();
        log.info((Object)"Qosd.start(): Preparing to load configuration");
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Qosd.start():setting application context for alarmListConnectionManager: m.context.toString:" + this.m_context.toString()));
            }
            alarmListConnectionManager.setapplicationcontext(this.m_context);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Qosd.start(): Error setting spring application context: " + ex);
        }
        try {
            this.config = QoSDConfigFactory.getConfig();
            log.info((Object)"QoSD QoSD-configuration.xml - Configuration Loaded Successfully");
            triggerUeiList = new Hashtable();
            String[] temp = this.config.getEventlist().getUei();
            for (int i = 0; i < temp.length; ++i) {
                triggerUeiList.put(temp[i], "1");
            }
        }
        catch (MarshalException mrshl_ex) {
            log.error((Object)"Qosd.start(): Marshal Exception thrown whilst getting QoSD configuration\n\t\t\t\tEnsure tags have correct names", (Throwable)mrshl_ex);
            throw new UndeclaredThrowableException(mrshl_ex);
        }
        catch (ValidationException vldtn_ex) {
            log.error((Object)"Qosd.start(): Validation Exception thrown whilst getting QoSD configuration\n\t\t\t\tMake sure all the tags are formatted correctly within QoSD-configuration.xml", (Throwable)vldtn_ex);
            throw new UndeclaredThrowableException(vldtn_ex);
        }
        catch (IOException io_ex) {
            String configFile = System.getProperty("opennms.home");
            if (configFile.endsWith(File.separator)) {
                configFile.substring(0, configFile.length() - 1);
            }
            configFile = configFile + "/etc/QoSD-configuration.xml";
            log.error((Object)("Qosd.start(): Failed to load configuration file: " + configFile + "\n\t\t\t\tMake sure that it exists"), (Throwable)io_ex);
            throw new UndeclaredThrowableException(io_ex);
        }
        if (useUeiList) {
            log.info((Object)"Qosd.start(): useUeiList = true = using QoSD QoSD-configuration.xml UEI list selects which alarms are sent");
        }
        try {
            props = PropertiesLoader.getInstance();
        }
        catch (FileNotFoundException fnf_ex) {
            String propertiesFilename = System.getProperty("propertiesFile");
            log.error((Object)("Qosd.start(): Could not find properties file: " + propertiesFilename), (Throwable)fnf_ex);
            throw new UndeclaredThrowableException(fnf_ex);
        }
        catch (IOException io_ex) {
            String propertiesFilename = System.getProperty("propertiesFile");
            log.error((Object)("Qosd.start(): Could not read from properties file: " + propertiesFilename + "\n\t\t\t\tPlease check the file permissions"), (Throwable)io_ex);
            throw new UndeclaredThrowableException(io_ex);
        }
        log.info((Object)"Qosd.start(): QosD Properties File Loaded");
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        if (props.getProperty("org.openoss.opennms.spring.qosd.naming.provider") != null) {
            jnp_host = props.getProperty("org.openoss.opennms.spring.qosd.naming.provider");
            log.info((Object)("Using JNP: " + jnp_host));
        } else {
            log.warn((Object)"Qosd.start(): Naming provider property not set, Using default: jnp://jbossjmsserver1:1099");
            jnp_host = "jnp://jbossjmsserver1:1099";
        }
        env = new Properties();
        env.setProperty("java.naming.provider.url", jnp_host);
        env.setProperty("java.naming.factory.initial", props.getProperty("org.openoss.opennms.spring.qosd.naming.contextfactory"));
        env.setProperty("java.naming.factory.url.pkgs", props.getProperty("org.openoss.opennms.spring.qosd.naming.pkg"));
        try {
            alarmListConnectionManager.init(props, env);
            alarmListConnectionManager.start();
            log.info((Object)"Qosd.start(): Waiting Connection Manager Thread to get JMS connection");
            while (alarmListConnectionManager.getStatus() != 0) {
            }
            log.info((Object)"Qosd.start(): Connection Manager Thread JMS connection successfully registered");
            log.info((Object)"Qosd.start(): openNMS just restarted - sending alarm list rebuilt event");
            alarmListConnectionManager.reset_list("openNMS just restarted - alarm list rebuilt. Time:" + new Date());
        }
        catch (Exception iae) {
            log.error((Object)"Qosd.start(): Exception caught starting alarmListConnectionManager", (Throwable)iae);
            throw new UndeclaredThrowableException(iae);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Qosd.start(): Using ossDao instance:" + (ossDao == null ? "IS NULL" : ossDao.toString())));
            }
            log.info((Object)"Qosd.start(): Initialising the Node and alarm Caches");
            ossDao.init();
            log.info((Object)"Qosd.start(): Set up ossDao call back interface to QoSD for forwarding changes to alarm list");
            ossDao.setQoSD(this);
        }
        catch (Exception ex) {
            log.error((Object)"Qosd.start(): Exception caught setting callback interface from ossDao", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        log.info((Object)"Qosd.start(): initialising OpenNMSEventHandlerThread");
        try {
            this.openNMSEventHandlerThread = new OpenNMSEventHandlerThread();
            this.openNMSEventHandlerThread.setossDao(ossDao);
            this.openNMSEventHandlerThread.init();
            this.openNMSEventHandlerThread.start();
        }
        catch (Exception ex) {
            log.error((Object)"Qosd.start(): Exception caught initialising OpenNMSEventHandlerThread", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        log.info((Object)"Qosd.start(): openNMS just restarted - sending all alarms in rebuilt alarm list");
        try {
            this.openNMSEventHandlerThread.sendAlarmList();
        }
        catch (Exception e) {
            log.error((Object)"Qosd.start(): problem sending initial alarm list Error:", (Throwable)e);
        }
        log.info((Object)"Qosd.start(): Starting OpenNMS event listener");
        try {
            this.registerListener();
        }
        catch (Exception e) {
            log.error((Object)"Qosd.start(): problem registering event listener Error:", (Throwable)e);
        }
        this.status = 2;
        log.info((Object)"QoSD Started");
    }

    public void stop() {
        Logger log = QoSDimpl2.getLog();
        log.info((Object)"Stopping QosD");
        this.status = 3;
        try {
            this.unregisterListener();
        }
        catch (Exception ex) {
            log.error((Object)"stop() Error unregistering the OpenNMS event listener. Error:", (Throwable)ex);
        }
        try {
            this.openNMSEventHandlerThread.kill();
        }
        catch (Exception ex) {
            log.error((Object)"stop() Error killing openNMSEventHandlerThread. Error:", (Throwable)ex);
        }
        try {
            alarmListConnectionManager.kill();
        }
        catch (Exception ex) {
            log.error((Object)"stop() Error killing alarmListConnectionManager. Error:", (Throwable)ex);
        }
        this.status = 4;
        log.info((Object)"QosD Stopped");
    }

    public void resume() {
        Logger log = QoSDimpl2.getLog();
        log.info((Object)"Resuming QosD");
        this.status = 7;
        this.registerListener();
        this.status = 2;
        log.info((Object)"QosD Resumed");
    }

    public void pause() {
        Logger log = QoSDimpl2.getLog();
        log.info((Object)"Pausing QosD");
        this.status = 5;
        this.unregisterListener();
        this.status = 6;
        log.info((Object)"QosD Paused");
    }

    public String getName() {
        return "OpenOSS.QoSD";
    }

    public int getStatus() {
        return this.status;
    }

    public void registerListener() {
        Logger log = QoSDimpl2.getLog();
        ArrayList<String> ueiList = new ArrayList<String>();
        String[] temp = this.config.getEventlist().getUei();
        for (int i = 0; i < temp.length; ++i) {
            ueiList.add(temp[i]);
        }
        log.info((Object)("QosD Registering for " + temp.length + " types of event"));
        eventIpcManager.addEventListener((EventListener)this, ueiList);
    }

    public void unregisterListener() {
        Logger log = QoSDimpl2.getLog();
        log.info((Object)"QosD Unregistering for events");
        eventIpcManager.removeEventListener((EventListener)this);
    }

    public void onEvent(Event event) {
        String s;
        Logger log = QoSDimpl2.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Qosd.onEvent: OpenNMS Event Detected by QosD. uei '" + event.getUei() + "' Dbid(): " + event.getDbid() + "  event.getTime(): " + event.getTime()));
        }
        if ((s = event.getUei()) == null) {
            return;
        }
        if ("uei.opennms.org/nodes/nodeAdded".equals(s) || "uei.opennms.org/nodes/nodeLabelChanged".equals(s) || "uei.opennms.org/nodes/nodeDeleted".equals(s) || "uei.opennms.org/nodes/assetInfoChanged".equals(s)) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"QosD.onEvent Event causing update to node list");
                }
                this.openNMSEventHandlerThread.updateNodeCache();
                return;
            }
            catch (Exception ex) {
                log.error((Object)("Qosd.onEvent. Problem calling openNMSEventHandlerThread.updateNodeCache(). Error:" + ex));
                return;
            }
        }
        if (event.getUei().equals("uei.opennms.org/vacuumd/alarmListChanged")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"QosD.onEvent received 'uei.opennms.org/vacuumd/alarmListChanged' event; Updating alarm list");
            }
        } else {
            try {
                if (event.getLogmsg().getDest().equals("donotpersist")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("QosD.onEvent Ignoring event marked as 'doNotPersist'. Event Uei:" + event.getUei()));
                    }
                    return;
                }
                if (event.getAlarmData().getAlarmType() == 2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Qosd.onEvent: uei '" + event.getUei() + "' Dbid(): " + event.getDbid() + " alarm type = 2 (clearing alarm) so ignoring."));
                    }
                    return;
                }
            }
            catch (NullPointerException e) {
                log.error((Object)("Qosd.onEvent: uei '" + event.getUei() + "' Dbid(): " + event.getDbid() + "' problem dealing with event. Check QoSD-configuration.xml."));
                return;
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"QosD.onEvent calling openNMSEventHandlerThread.sendAlarmList() to update list.");
            }
            this.openNMSEventHandlerThread.sendAlarmList();
        }
        catch (Exception ex) {
            log.error((Object)("Qosd.onEvent. Problem calling openNMSEventHandlerThread.sendAlarmList(). Error:" + ex));
        }
    }

    public void sendAlarms() {
        Logger log = QoSDimpl2.getLog();
        Hashtable<AlarmKey, AlarmValue> ossjAlarmUpdateList = new Hashtable<AlarmKey, AlarmValue>();
        OnmsAlarm[] onmsAlarmUpdateList = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"sendAlarms() using ossDao to get current alarm list");
            }
            onmsAlarmUpdateList = ossDao.getAlarmCache();
        }
        catch (Exception ex) {
            log.error((Object)"sendAlarms() Cannot retrieve alarms from ossDao.getAlarmCache()", (Throwable)ex);
            throw new UndeclaredThrowableException(ex, "sendAlarms() Cannot retrieve alarms from ossDao.getAlarmCache()");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendAlarms() Alarms fetched. Processing each alarm in list.");
        }
        try {
            for (int i = 0; i < onmsAlarmUpdateList.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sendAlarms() processing an OpenNMS alarm:");
                }
                if (useUeiList) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"sendAlarms() useUeiList= true: using UeiList to determine alarms to send");
                    }
                    if (null == triggerUeiList.get(onmsAlarmUpdateList[i].getUei())) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("sendAlarms() alarm UEI not in QosD-configuration.xml. Not sending. alarmID:" + onmsAlarmUpdateList[i].getId() + " alarmUEI:" + onmsAlarmUpdateList[i].getUei()));
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("sendAlarms() alarm UEI is in QosD-configuration.xml. Trying to send alarmID:" + onmsAlarmUpdateList[i].getId() + " alarmUEI:" + onmsAlarmUpdateList[i].getUei()));
                    }
                }
                if (onmsAlarmUpdateList[i].getAlarmType() != 1) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("sendAlarms() Alarm AlarmType !=1 ( not raise alarm ) Not sending alarmID:" + onmsAlarmUpdateList[i].getId() + " :alarmBuf[i].getQosAlarmState()=: " + onmsAlarmUpdateList[i].getQosAlarmState()));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("sendAlarms() Alarm AlarmType==1 ( raise alarm ) Sending alarmID:" + onmsAlarmUpdateList[i].getId() + " :alarmBuf[i].getQosAlarmState()=: " + onmsAlarmUpdateList[i].getQosAlarmState()));
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"sendAlarms(): generating the OSS/J alarm specification:");
                    }
                    AlarmValue ossjAlarm = alarmListConnectionManager.makeAlarmValueFromSpec();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("sendAlarms(): OSS/J alarm specification:" + OOSSAlarmValue.converttoString((AlarmValue)ossjAlarm)));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"sendAlarms(): onmsAlarmOssjMapper.populateOssjAlarmFromOpenNMSAlarm:");
                    }
                    ossjAlarm = onmsAlarmOssjMapper.populateOssjAlarmFromOpenNMSAlarm(ossjAlarm, onmsAlarmUpdateList[i]);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("buildList(): alarm specifcation:" + OOSSAlarmValue.converttoString((AlarmValue)ossjAlarm)));
                    }
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"sendAlarms() including ACKNOWLEDGED and CLEARED alarms in alarm in list");
                        }
                        ossjAlarmUpdateList.put(ossjAlarm.getAlarmKey(), ossjAlarm);
                    }
                    catch (Exception e) {
                        log.error((Object)"sendAlarms() error putting alarm in alarmList", (Throwable)e);
                    }
                    continue;
                }
                catch (Exception ex) {
                    log.error((Object)"sendAlarms() error trying to populate alarm - alarm disguarded - check alarm definitons", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"Qosd.sendAlarms(): Problem when building alarm list:", (Throwable)ex);
            throw new UndeclaredThrowableException(ex, "Qosd.sendAlarms(): Problem when building alarm list");
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"QosD sendAlarms() - Alarm list built:");
                Enumeration test = ossjAlarmUpdateList.keys();
                log.debug((Object)"QosD sendAlarms() - ******* Alarm List to be sent : primary keys");
                while (test.hasMoreElements()) {
                    AlarmKey key = (AlarmKey)test.nextElement();
                    AlarmValue a = (AlarmValue)ossjAlarmUpdateList.get(key);
                    log.debug((Object)("QosD sendAlarms() key : " + key.getPrimaryKey() + "  AlarmValue.getAlarmChangedTime: " + a.getAlarmChangedTime()));
                }
                log.debug((Object)"QosD sendAlarms() - ******* END OF LIST");
                log.debug((Object)"QosD sendAlarms() Sending alarm list to bean");
            }
            alarmListConnectionManager.send(ossjAlarmUpdateList);
        }
        catch (Exception ex) {
            log.error((Object)"Qosd.sendAlarms(): Problem when sending alarm list:", (Throwable)ex);
            throw new UndeclaredThrowableException(ex, "Qosd.sendAlarms(): Problem when sending alarm list");
        }
    }

    public String getStats() {
        return m_stats == null ? "No Stats Available" : m_stats.toString();
    }

    static {
        m_stats = null;
        useUeiList = false;
    }
}

