/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.qosd;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class PropertiesLoader {
    private static PropertiesLoader instance = null;
    private final HashMap<String, String> properties = new HashMap();

    private PropertiesLoader() throws FileNotFoundException, IOException {
        Properties props = new Properties();
        String propertiesFilename = System.getProperty("propertiesFile");
        if (propertiesFilename == null) {
            throw new FileNotFoundException();
        }
        FileInputStream inStream = new FileInputStream(propertiesFilename);
        props.load(inStream);
        inStream.close();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = props.getProperty(key);
            this.properties.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PropertiesLoader getInstance() throws FileNotFoundException, IOException {
        if (instance != null) return instance;
        Class<PropertiesLoader> clazz = PropertiesLoader.class;
        synchronized (PropertiesLoader.class) {
            if (instance != null) return instance;
            instance = new PropertiesLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getProperty(String propertyName) throws IllegalArgumentException {
        String _out = this.properties.get(propertyName);
        if (_out == null) {
            throw new IllegalArgumentException();
        }
        return _out;
    }

    public Set getPropertyNames() {
        return this.properties.keySet();
    }
}

