/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.opennms.spring.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.oss.UnsupportedAttributeException;
import javax.oss.fm.monitor.AlarmKey;
import javax.oss.fm.monitor.AlarmValue;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.openoss.opennms.spring.dao.OssDaoOpenNMSImpl;
import org.openoss.opennms.spring.qosdrx.QoSDrx;
import org.openoss.ossj.jvt.fm.monitor.OOSSProbableCause;

public class OnmsAlarmOssjMapper {
    private static final String LOG4J_CATEGORY = "OpenOSS.QoSD";
    private Pattern p = Pattern.compile("<[^>]*>");
    private Matcher matcher;
    private static DistPollerDao distPollerDao;
    private static AssetRecordDao _assetRecordDao;
    private static NodeDao _nodeDao;
    private static OssDaoOpenNMSImpl ossDao;
    public static int SPECIFY_OUTSTATION;
    public static int USE_TYPE_INSTANCE;
    private static String[] alarmUpdateBehaviourStr;

    private static Logger getLog() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        return (Logger)ThreadCategory.getInstance(QoSDrx.class);
    }

    public void setdistPollerDao(DistPollerDao _distPollerDao) {
        distPollerDao = _distPollerDao;
    }

    public void setassetRecordDao(AssetRecordDao ar) {
        _assetRecordDao = ar;
    }

    public void setnodeDao(NodeDao nodedao) {
        _nodeDao = nodedao;
    }

    public void setossDao(OssDaoOpenNMSImpl _ossDao) {
        ossDao = _ossDao;
    }

    public static String getAlarmUpdateBehaviourForInt(Integer aub) {
        try {
            return alarmUpdateBehaviourStr[aub];
        }
        catch (Exception ex) {
            return "getAlarmUpdateBehaviourForInt INVALID_VALUE:" + aub;
        }
    }

    public static Integer getalarmUpdateBehaviourForString(String _alarmUpdateBehaviour) {
        Integer almUpdateBehaviour = null;
        if (_alarmUpdateBehaviour == null) {
            throw new IllegalArgumentException("getalarmUpdateBehaviourForString: Null value for alarmUpdateBehaviour");
        }
        if (_alarmUpdateBehaviour.equals("USE_TYPE_INSTANCE")) {
            almUpdateBehaviour = USE_TYPE_INSTANCE;
            return almUpdateBehaviour;
        }
        if (_alarmUpdateBehaviour.equals("SPECIFY_OUTSTATION")) {
            almUpdateBehaviour = SPECIFY_OUTSTATION;
            return almUpdateBehaviour;
        }
        throw new IllegalArgumentException("getalarmUpdateBehaviourForString: Unknown value for alarmUpdateBehaviour:" + _alarmUpdateBehaviour);
    }

    public OnmsAlarm populateOnmsAlarmFromOssjAlarm(OnmsAlarm onmsAlarm, AlarmValue alarmValue, Integer almUpdateBehaviour, String defaultUpdateNodeLabel) throws IllegalArgumentException, UnsupportedAttributeException {
        block28: {
            Logger log = OnmsAlarmOssjMapper.getLog();
            String logheader = "\t\t" + this.getClass().getSimpleName() + "populateOnmsAlarmFromOssjAlarm():";
            try {
                String applicationDN;
                block29: {
                    Integer onmsseverity;
                    String ossPrimaryKey = alarmValue.getAlarmKey().getAlarmPrimaryKey();
                    applicationDN = alarmValue.getAlarmKey().getApplicationDN();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(logheader + " - AlarmPrimaryKey: " + ossPrimaryKey + " ApplictionDN: " + applicationDN + " alarmRaisedTime: " + alarmValue.getAlarmRaisedTime()));
                    }
                    if (applicationDN == null || applicationDN.equals("") || ossPrimaryKey == null || ossPrimaryKey.equals("")) {
                        log.error((Object)(logheader + " ApplicatioDN or PrimaryKey not set"));
                        break block28;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(logheader + ": trying to find existing alarm using getCurrentAlarmForUniqueKey"));
                    }
                    if ((onmsAlarm = ossDao.getCurrentAlarmForUniqueKey(applicationDN, ossPrimaryKey)) != null) {
                        log.error((Object)(logheader + " Alarm Already exists with this Unique ID"));
                        break block28;
                    }
                    onmsAlarm = new OnmsAlarm();
                    onmsAlarm.setUei(this.ossjAlarmTypeToUei(alarmValue.getAlarmType()));
                    onmsAlarm.setX733AlarmType(alarmValue.getAlarmType() == null ? "" : alarmValue.getAlarmType());
                    onmsAlarm.setX733ProbableCause((int)alarmValue.getProbableCause());
                    onmsAlarm.setTTicketState(null);
                    onmsAlarm.setTTicketId("");
                    onmsAlarm.setQosAlarmState("");
                    onmsAlarm.setSuppressedUser("");
                    onmsAlarm.setSuppressedUntil(new Date());
                    onmsAlarm.setSuppressedTime(new Date());
                    try {
                        onmsseverity = this.ossjSeveritytoOnmsSeverity(alarmValue.getPerceivedSeverity());
                    }
                    catch (IllegalArgumentException iae) {
                        log.error((Object)(logheader + " problem setting severity used default:'WARNING'. Exception:" + iae));
                        onmsseverity = new Integer(4);
                    }
                    onmsAlarm.setSeverity(onmsseverity);
                    OnmsServiceType service = new OnmsServiceType();
                    service.setId(new Integer(-1));
                    onmsAlarm.setServiceType(new OnmsServiceType());
                    onmsAlarm.setReductionKey(":managedObjectInstance:" + alarmValue.getManagedObjectInstance() + ":managedObjectType:" + alarmValue.getManagedObjectClass() + ":ossPrimaryKey:-" + ossPrimaryKey + ":applicationDN:-" + applicationDN);
                    onmsAlarm.setOssPrimaryKey(ossPrimaryKey);
                    onmsAlarm.setOperInstruct(alarmValue.getProposedRepairActions());
                    OnmsNode node = new OnmsNode();
                    node.setId(new Integer(1));
                    onmsAlarm.setNode(node);
                    if (almUpdateBehaviour == null) {
                        log.error((Object)(logheader + ": This receiver's alarmUpdateBehaviour is not set: defaulting to update nodeID:1"));
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(logheader + " alarmUpdateBehaviour:" + almUpdateBehaviour + " " + OnmsAlarmOssjMapper.getAlarmUpdateBehaviourForInt(almUpdateBehaviour)));
                        }
                        if (almUpdateBehaviour.equals(SPECIFY_OUTSTATION)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(logheader + " SPECIFY_OUTSTATION looking for node with nodelabel:" + defaultUpdateNodeLabel));
                            }
                            try {
                                try {
                                    node = ossDao.findNodeByLabel(defaultUpdateNodeLabel);
                                }
                                catch (Exception ex) {
                                    log.error((Object)(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE) Problem looking up Node " + ex));
                                }
                                if (node != null) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)(logheader + " alarmUpdateBehaviour.equals(SPECIFY_OUTSTATION):" + "NODE FOUND for this name:" + defaultUpdateNodeLabel + " setting node id to NodeLabel:" + node.getLabel() + " NodeID:" + node.getId()));
                                    }
                                    onmsAlarm.setNode(node);
                                    break block29;
                                }
                                log.error((Object)(logheader + " alarmUpdateBehaviour.equals(SPECIFY_OUTSTATION):" + "NODE NOT FOUND for this name:" + defaultUpdateNodeLabel + " setting node id to default NodeID: 1"));
                                node = new OnmsNode();
                                node.setId(new Integer(1));
                                onmsAlarm.setNode(node);
                            }
                            catch (Exception ex) {
                                log.error((Object)(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE) Problem looking up Node for alarm Set to default nodeID:1" + ex));
                            }
                        } else if (almUpdateBehaviour.equals(USE_TYPE_INSTANCE)) {
                            String managedObjectType = alarmValue.getManagedObjectClass();
                            String managedObjectInstance = alarmValue.getManagedObjectInstance();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(logheader + " USE_TYPE_INSTANCE looking for node with managedObjectType:" + managedObjectType + " managedObjectInstance:" + managedObjectInstance));
                            }
                            try {
                                node = ossDao.findNodeByInstanceAndType(managedObjectInstance, managedObjectType);
                                if (node != null) {
                                    if (log.isDebugEnabled()) {
                                        log.debug((Object)(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE):" + "NODE FOUND for this RX Name:" + defaultUpdateNodeLabel + " setting node id to NodeLabel:" + node.getLabel() + " NodeID:" + node.getId()));
                                    }
                                    onmsAlarm.setNode(node);
                                    break block29;
                                }
                                log.error((Object)(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE):" + "NODE NOT FOUND for this managedObjectType:" + managedObjectType + " managedObjectInstance:" + managedObjectInstance + " setting node id to default NodeID: 1"));
                                node = new OnmsNode();
                                node.setId(new Integer(1));
                                onmsAlarm.setNode(node);
                            }
                            catch (Exception ex) {
                                log.error((Object)(logheader + " alarmUpdateBehaviour.equals(USE_TYPE_INSTANCE) Problem looking up Node for alarm Set to default nodeID:1" + ex));
                            }
                        } else {
                            log.error((Object)(logheader + " Invalid value for alarmUpdateBehaviour:" + almUpdateBehaviour + " " + OnmsAlarmOssjMapper.getAlarmUpdateBehaviourForInt(almUpdateBehaviour) + " defaulting to update nodeID:1"));
                        }
                    }
                }
                onmsAlarm.setMouseOverText("");
                onmsAlarm.setManagedObjectType(alarmValue.getManagedObjectClass());
                onmsAlarm.setManagedObjectInstance(alarmValue.getManagedObjectInstance());
                onmsAlarm.setLogMsg(alarmValue.getSpecificProblem());
                onmsAlarm.setIpAddr("localhost");
                onmsAlarm.setId(null);
                onmsAlarm.setFirstEventTime(alarmValue.getAlarmRaisedTime());
                onmsAlarm.setLastEventTime(alarmValue.getAlarmChangedTime());
                onmsAlarm.setDistPoller((OnmsDistPoller)distPollerDao.get((Serializable)((Object)"localhost")));
                onmsAlarm.setDescription(alarmValue.getAdditionalText());
                onmsAlarm.setCounter(new Integer(1));
                onmsAlarm.setClearUei("");
                onmsAlarm.setApplicationDN(applicationDN);
                onmsAlarm.setAlarmType(new Integer(1));
                if (log.isDebugEnabled()) {
                    log.debug((Object)(logheader + ": Creating Alarm: "));
                }
            }
            catch (Exception e) {
                log.error((Object)(logheader + " Error : "), (Throwable)e);
            }
        }
        return onmsAlarm;
    }

    public AlarmValue populateOssjAlarmFromOpenNMSAlarm(AlarmValue alarmValueSpecification, OnmsAlarm _openNMSalarm) throws IllegalArgumentException, UnsupportedAttributeException {
        String _opinstr;
        Logger log = OnmsAlarmOssjMapper.getLog();
        String logheader = "\t\t" + this.getClass().getSimpleName() + "populateOssjAlarmFromOpenNMSAlarm():";
        OnmsNode node = null;
        OnmsAssetRecord asset = null;
        boolean isQoSDrxAlarm = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)(logheader + ": Populating alarm"));
        }
        if (_openNMSalarm.getManagedObjectInstance() != null && _openNMSalarm.getManagedObjectType() != null && !_openNMSalarm.getManagedObjectInstance().equals("") && !_openNMSalarm.getManagedObjectType().equals("")) {
            isQoSDrxAlarm = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)(logheader + ": isQoSDrxAlarm TRUE - because OpenNMS alarm has ManagedObjectInstance and ManagedObjectType"));
            }
        } else {
            isQoSDrxAlarm = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)(logheader + ": isQoSDrxAlarm FALSE - because OpenNMS alarm NOT POPULATED ManagedObjectInstance and ManagedObjectType"));
            }
        }
        try {
            if (null != _openNMSalarm.getAlarmAckTime() && null != _openNMSalarm.getAlarmAckUser()) {
                alarmValueSpecification.setAckUserId(_openNMSalarm.getAlarmAckUser());
                alarmValueSpecification.setAckTime(new Date(_openNMSalarm.getAlarmAckTime().getTime()));
                alarmValueSpecification.setAlarmAckState(1);
            } else {
                alarmValueSpecification.setAlarmAckState(2);
            }
            if (_openNMSalarm.getSeverity() == 2) {
                alarmValueSpecification.setAlarmClearedTime(new Date(_openNMSalarm.getLastEventTime().getTime()));
            } else {
                alarmValueSpecification.setAlarmClearedTime(null);
            }
            if (null != _openNMSalarm.getFirstEventTime()) {
                alarmValueSpecification.setAlarmRaisedTime(new Date(_openNMSalarm.getFirstEventTime().getTime()));
            }
            if (null != _openNMSalarm.getLastEventTime()) {
                alarmValueSpecification.setAlarmChangedTime(new Date(_openNMSalarm.getLastEventTime().getTime()));
            }
        }
        catch (Exception e) {
            log.error((Object)(logheader + ": Problem getting ACK time information"), (Throwable)e);
        }
        String _uei_no_html = "NOT_SET";
        try {
            String uei = _openNMSalarm.getUei();
            if (null != uei) {
                this.matcher = this.p.matcher(uei);
                _uei_no_html = this.matcher.replaceAll(" ");
            }
            alarmValueSpecification.setAlarmType(_openNMSalarm.getX733AlarmType() == null ? "EquipmentAlarm" : _openNMSalarm.getX733AlarmType());
        }
        catch (Exception e) {
            log.error((Object)(logheader + ": Problem getting  X733AlarmType or Uei"), (Throwable)e);
        }
        String mftr = "NOT_SET";
        String modelNo = "NOT_SET";
        String assetserno = "NOT_SET";
        String nodelabel = "NOT_SET";
        String alarmIP = "NOT_SET";
        String managedObjectType = "NOT_SET";
        String managedObjectInstance = "NOT_SET";
        String assetManagedObjectType = "NOT_SET";
        String assetManagedObjectInstance = "NOT_SET";
        String assetDescription = "NOT_SET";
        String assetAddress2 = "NOT_SET";
        if (!isQoSDrxAlarm) {
            try {
                node = ossDao.findNodeByID(_openNMSalarm.getNode().getId());
                asset = node.getAssetRecord();
                alarmIP = _openNMSalarm.getIpAddr();
                if (node != null) {
                    nodelabel = node.getLabel();
                }
                if (asset != null) {
                    if (asset.getManufacturer() != null) {
                        mftr = asset.getManufacturer();
                    }
                    if (asset.getModelNumber() != null) {
                        modelNo = asset.getModelNumber();
                    }
                    if (asset.getSerialNumber() != null) {
                        assetserno = asset.getSerialNumber();
                    }
                    if (asset.getDescription() != null) {
                        assetDescription = asset.getDescription();
                    }
                    if (asset.getAddress2() != null) {
                        assetAddress2 = asset.getAddress2();
                    }
                    if (asset.getManagedObjectInstance() != null) {
                        assetManagedObjectInstance = asset.getManagedObjectInstance();
                    }
                    if (asset.getManagedObjectType() != null) {
                        assetManagedObjectType = asset.getManagedObjectType();
                    }
                }
                managedObjectInstance = assetManagedObjectInstance;
                managedObjectType = assetManagedObjectType;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(logheader + ": isQoSDrxAlarm=FALSE  OpenNMS type and instance not set. Using from Node Asset record: ManagedObjectInstance: " + managedObjectInstance + " ManagedObjectType:" + managedObjectType));
                }
            }
            catch (Exception ex) {
                log.error((Object)(logheader + ": Problem getting node and asset information"), (Throwable)ex);
            }
        } else {
            try {
                managedObjectInstance = _openNMSalarm.getManagedObjectInstance();
                managedObjectType = _openNMSalarm.getManagedObjectType();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(logheader + ": isQoSDrxAlarm=TRUE  OpenNMS type and instance set. Using from OnmsAlarm: ManagedObjectInstance: " + managedObjectInstance + " ManagedObjectType:" + managedObjectType));
                }
            }
            catch (Exception ex) {
                log.error((Object)(logheader + ": Problem managedObjectInstance or managedObjectType"), (Throwable)ex);
            }
        }
        alarmValueSpecification.setManagedObjectClass(managedObjectType);
        if (log.isDebugEnabled()) {
            log.debug((Object)(logheader + ": _av.setManagedObjectClass set to: " + managedObjectType));
        }
        alarmValueSpecification.setManagedObjectInstance(managedObjectInstance);
        if (log.isDebugEnabled()) {
            log.debug((Object)(logheader + ": _av.setManagedObjectInstance set to: " + managedObjectInstance));
        }
        try {
            alarmValueSpecification.setPerceivedSeverity(this.onmsSeverityToOssjSeverity(_openNMSalarm.getSeverity()));
            alarmValueSpecification.setProbableCause((short)_openNMSalarm.getX733ProbableCause());
        }
        catch (Exception e) {
            log.error((Object)(logheader + ": Problem getting severity or probable cause: "), (Throwable)e);
        }
        if (!isQoSDrxAlarm) {
            try {
                String x733ProbableCause;
                _opinstr = _openNMSalarm.getOperInstruct();
                if (null != _opinstr) {
                    this.matcher = this.p.matcher(_opinstr);
                    _opinstr = this.matcher.replaceAll(" ");
                } else {
                    _opinstr = "NOT_SET";
                }
                alarmValueSpecification.setProposedRepairActions(_opinstr);
                String _logmsg = _openNMSalarm.getLogMsg();
                if (null != _logmsg) {
                    this.matcher = this.p.matcher(_logmsg);
                    _logmsg = this.matcher.replaceAll(" ");
                } else {
                    _logmsg = "NOT_SET";
                }
                String _description = _openNMSalarm.getDescription();
                if (null != _description) {
                    this.matcher = this.p.matcher(_description);
                    _description = this.matcher.replaceAll(" ");
                } else {
                    _description = "NOT_SET";
                }
                alarmValueSpecification.setSpecificProblem(_logmsg);
                Integer alarmid = _openNMSalarm.getId();
                Integer counter = _openNMSalarm.getCounter();
                String reductionkey = _openNMSalarm.getReductionKey();
                Integer nodeid = _openNMSalarm.getNode().getId();
                String onmsnodelabel = _openNMSalarm.getNode().getLabel();
                String ipaddress = _openNMSalarm.getIpAddr();
                String x733AlarmType = _openNMSalarm.getX733AlarmType();
                try {
                    x733ProbableCause = OOSSProbableCause.getStringforEnum((short)((short)_openNMSalarm.getX733ProbableCause()));
                }
                catch (Exception e) {
                    x733ProbableCause = "X733 Probable Cause Incorrectly Defined";
                }
                alarmValueSpecification.setAdditionalText("<alarmid>" + alarmid + "</alarmid>" + "\n            " + "<logmsg>" + _logmsg + "</logmsg>" + "\n            " + "<uei>" + _uei_no_html + "<uei>" + "\n            " + "<x733AlarmType>" + x733AlarmType + "</x733AlarmType>" + "\n            " + "<x733ProbableCause>" + x733ProbableCause + "</x733ProbableCause>" + "\n            " + "<counter>" + counter + "</counter>" + "\n            " + "<reductionkey>" + reductionkey + "</reductionkey>" + "\n            " + "<nodeid>" + nodeid + "</nodeid>" + "\n            " + "<nodelabel>" + onmsnodelabel + "</nodelabel>" + "\n            " + "<ipaddress>" + ipaddress + "</ipaddress>" + "\n            " + "<description>" + _description + "</description>" + "\n            " + "<opinstr>" + _opinstr + "</opinstr>" + "\n            " + "<asset.managedobjectinstance>" + assetManagedObjectInstance + "</asset.managedobjectinstance>" + "\n            " + "<asset.managedobjecttype>" + assetManagedObjectType + "</asset.managedobjecttype>" + "\n            " + "<asset.address2>" + assetAddress2 + "</asset.address2>" + "\n            " + "<asset.description>" + assetDescription + "</asset.description>" + "\n");
            }
            catch (Exception e) {
                log.error((Object)(logheader + ": Problem setting description, logmessage or operator instrctions: "), (Throwable)e);
            }
        } else {
            try {
                _opinstr = _openNMSalarm.getOperInstruct();
                if (null == _opinstr) {
                    _opinstr = "NOT_SET";
                }
                alarmValueSpecification.setProposedRepairActions(_opinstr);
                String _logmsg = _openNMSalarm.getLogMsg();
                if (null == _logmsg) {
                    _logmsg = "NOT_SET";
                }
                alarmValueSpecification.setSpecificProblem(_logmsg);
                String _description = _openNMSalarm.getDescription();
                if (null == _description) {
                    _description = "NOT_SET";
                }
                alarmValueSpecification.setAdditionalText(_description);
            }
            catch (Exception e) {
                log.error((Object)(logheader + ": Problem setting description, logmessage or operator instrctions: "), (Throwable)e);
            }
        }
        try {
            AlarmKey ak = alarmValueSpecification.getAlarmKey();
            ak.setAlarmPrimaryKey(Integer.toString(_openNMSalarm.getId()));
            ak.setPrimaryKey((Object)ak.getAlarmPrimaryKey());
        }
        catch (Exception e) {
            log.error((Object)(logheader + ": Problem setting AlarmKey: "), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(logheader + ": Alarm Populated"));
        }
        return alarmValueSpecification;
    }

    public Integer ossjSeveritytoOnmsSeverity(short ossjseverity) throws IllegalArgumentException {
        int onmsseverity = 0;
        switch (ossjseverity) {
            case 1: {
                onmsseverity = 1;
                break;
            }
            case 6: {
                onmsseverity = 2;
                break;
            }
            case 5: {
                onmsseverity = 4;
                break;
            }
            case 4: {
                onmsseverity = 5;
                break;
            }
            case 3: {
                onmsseverity = 6;
                break;
            }
            case 2: {
                onmsseverity = 7;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid OSS/J severity value:" + ossjseverity);
            }
        }
        return new Integer(onmsseverity);
    }

    public short onmsSeverityToOssjSeverity(Integer onmsSeverity) throws IllegalArgumentException {
        short ossjseverity = 0;
        if (onmsSeverity == null) {
            throw new IllegalArgumentException("onmsSeverityToOssjSeverity: onmsSeverity is Null");
        }
        switch (onmsSeverity) {
            case 1: {
                ossjseverity = 1;
                break;
            }
            case 2: {
                ossjseverity = 6;
                break;
            }
            case 3: {
                ossjseverity = 5;
                break;
            }
            case 4: {
                ossjseverity = 5;
                break;
            }
            case 5: {
                ossjseverity = 4;
                break;
            }
            case 6: {
                ossjseverity = 3;
                break;
            }
            case 7: {
                ossjseverity = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid OpenNMS severity value:" + onmsSeverity);
            }
        }
        return ossjseverity;
    }

    public String ossjAlarmTypeToUei(String alarmType) {
        if (alarmType == null) {
            return "uei.openoss.org.alarm/unknown";
        }
        if (alarmType.equals("CommunicationsAlarm")) {
            return "uei.openoss.org.alarm/CommunicationsAlarm";
        }
        if (alarmType.equals("EnvironmentalAlarm")) {
            return "uei.openoss.org.alarm/EnvironmentalAlarm";
        }
        if (alarmType.equals("EquipmentAlarm")) {
            return "uei.openoss.org.alarm/EquipmentAlarm";
        }
        if (alarmType.equals("IntegrityViolation")) {
            return "uei.openoss.org.alarm/IntegrityViolation";
        }
        if (alarmType.equals("OperationalViolation")) {
            return "uei.openoss.org.alarm/OperationalViolation";
        }
        if (alarmType.equals("PhysicalViolation")) {
            return "uei.openoss.org.alarm/PhysicalViolation";
        }
        if (alarmType.equals("ProcessingErrorAlarm")) {
            return "uei.openoss.org.alarm/ProcessingErrorAlarm";
        }
        if (alarmType.equals("QualityOfServiceAlarm")) {
            return "uei.openoss.org.alarm/QualityOfServiceAlarm";
        }
        if (alarmType.equals("SecurityViolation")) {
            return "uei.openoss.org.alarm/SecurityViolation";
        }
        if (alarmType.equals("TimeDomainViolation")) {
            return "uei.openoss.org.alarm/TimeDomainViolation";
        }
        return "uei.openoss.org.alarm/unknown";
    }

    static {
        SPECIFY_OUTSTATION = 1;
        USE_TYPE_INSTANCE = 2;
        alarmUpdateBehaviourStr = new String[]{"SPECIFY_OUTSTATION", "USE_TYPE_INSTANCE"};
    }
}

