/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.cglib;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.NoOp;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.pojo.BasicLazyInitializer;
import org.hibernate.proxy.pojo.cglib.SerializableProxy;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.util.ReflectHelper;

public final class CGLIBLazyInitializer
extends BasicLazyInitializer
implements InvocationHandler {
    private static final CallbackFilter FINALIZE_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            if (method.getParameterTypes().length == 0 && method.getName().equals("finalize")) {
                return 1;
            }
            return 0;
        }
    };
    private Class[] interfaces;
    private boolean constructed = false;

    static HibernateProxy getProxy(String entityName, Class persistentClass, Class[] interfaces, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, Serializable id, SessionImplementor session) throws HibernateException {
        try {
            CGLIBLazyInitializer instance = new CGLIBLazyInitializer(entityName, persistentClass, interfaces, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
            Class factory = CGLIBLazyInitializer.getProxyFactory(persistentClass, interfaces);
            Enhancer.registerCallbacks((Class)factory, (Callback[])new Callback[]{instance, null});
            HibernateProxy proxy = (HibernateProxy)factory.newInstance();
            instance.constructed = true;
            return proxy;
        }
        catch (Throwable t) {
            LogFactory.getLog((Class)BasicLazyInitializer.class).error((Object)("CGLIB Enhancement failed: " + entityName), t);
            throw new HibernateException("CGLIB Enhancement failed: " + entityName, t);
        }
    }

    public static HibernateProxy getProxy(Class factory, String entityName, Class persistentClass, Class[] interfaces, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, Serializable id, SessionImplementor session) throws HibernateException {
        HibernateProxy proxy;
        CGLIBLazyInitializer instance = new CGLIBLazyInitializer(entityName, persistentClass, interfaces, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
        try {
            Enhancer.registerCallbacks((Class)factory, (Callback[])new Callback[]{instance, null});
            proxy = (HibernateProxy)factory.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("CGLIB Enhancement failed: " + persistentClass.getName(), e);
        }
        instance.constructed = true;
        return proxy;
    }

    public static Class getProxyFactory(Class persistentClass, Class[] interfaces) throws HibernateException {
        Enhancer e = new Enhancer();
        e.setSuperclass(interfaces.length == 1 ? persistentClass : null);
        e.setInterfaces(interfaces);
        e.setCallbackTypes(new Class[]{InvocationHandler.class, NoOp.class});
        e.setCallbackFilter(FINALIZE_FILTER);
        e.setUseFactory(false);
        e.setInterceptDuringConstruction(false);
        return e.createClass();
    }

    private CGLIBLazyInitializer(String entityName, Class persistentClass, Class[] interfaces, Serializable id, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, SessionImplementor session) {
        super(entityName, persistentClass, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
        this.interfaces = interfaces;
    }

    private static boolean isCastable(Class caster, Class castee) {
        if (castee.equals(caster)) {
            return true;
        }
        List list = CGLIBLazyInitializer.addCheckingTypes(caster, new ArrayList());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Class cl = (Class)iter.next();
            if (!castee.equals(cl)) continue;
            return true;
        }
        return false;
    }

    private static List addCheckingTypes(Class type, List list) {
        Class superclass = type.getSuperclass();
        if (superclass != null) {
            list.add(superclass);
            CGLIBLazyInitializer.addCheckingTypes(superclass, list);
        }
        Class<?>[] interfaces = type.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            list.add(interfaces[i]);
            CGLIBLazyInitializer.addCheckingTypes(interfaces[i], list);
        }
        return list;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.constructed) {
            Object result = this.invoke(method, args, proxy);
            if (result == INVOKE_IMPLEMENTATION) {
                Object target = this.getImplementation();
                try {
                    Object returnValue;
                    if (ReflectHelper.isPublic(this.persistentClass, method)) {
                        if (!CGLIBLazyInitializer.isCastable(target.getClass(), method.getDeclaringClass())) {
                            throw new ClassCastException(target.getClass().getName());
                        }
                        returnValue = method.invoke(target, args);
                    } else {
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        returnValue = method.invoke(target, args);
                    }
                    return returnValue == target ? proxy : returnValue;
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            return result;
        }
        if (method.getName().equals("getHibernateLazyInitializer")) {
            return this;
        }
        throw new LazyInitializationException("unexpected case hit, method=" + method.getName());
    }

    protected Object serializableProxy() {
        return new SerializableProxy(this.getEntityName(), this.persistentClass, this.interfaces, this.getIdentifier(), this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType);
    }
}

