/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;

public class IpListFromUrl {
    private static final String COMMENT_STR = " #";
    private static final char COMMENT_CHAR = '#';

    public static List parse(String url) {
        ArrayList<String> iplist = new ArrayList<String>();
        try {
            URL fileURL = new URL(url);
            InputStream file = fileURL.openStream();
            if (file != null) {
                BufferedReader buffer = new BufferedReader(new InputStreamReader(file));
                String ipLine = null;
                String specIP = null;
                while ((ipLine = buffer.readLine()) != null) {
                    if ((ipLine = ipLine.trim()).length() == 0 || ipLine.charAt(0) == '#') continue;
                    int comIndex = ipLine.indexOf(COMMENT_STR);
                    if (comIndex == -1) {
                        specIP = ipLine;
                    } else {
                        specIP = ipLine.substring(0, comIndex);
                        ipLine = ipLine.trim();
                    }
                    iplist.add(specIP);
                }
                buffer.close();
            } else {
                ThreadCategory.getInstance(IpListFromUrl.class).warn((Object)("URL does not exist: " + url.toString()));
            }
        }
        catch (MalformedURLException e) {
            ThreadCategory.getInstance(IpListFromUrl.class).error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
        }
        catch (FileNotFoundException e) {
            ThreadCategory.getInstance(IpListFromUrl.class).error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
        }
        catch (IOException e) {
            ThreadCategory.getInstance(IpListFromUrl.class).error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
        }
        return iplist;
    }
}

