/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.Window;
import org.apache.batik.script.rhino.BatikSecuritySupport;
import org.apache.batik.script.rhino.EventTargetWrapHandler;
import org.apache.batik.script.rhino.EventTargetWrapper;
import org.apache.batik.script.rhino.RhinoClassLoader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.WrapHandler;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.events.EventTarget;

public class RhinoInterpreter
implements Interpreter {
    private static String[] TO_BE_IMPORTED = new String[]{"java.lang", "org.w3c.dom", "org.w3c.dom.css", "org.w3c.dom.events", "org.w3c.dom.smil", "org.w3c.dom.stylesheets", "org.w3c.dom.svg", "org.w3c.dom.views"};
    private static final int MAX_CACHED_SCRIPTS = 32;
    public static final String SOURCE_NAME_SVG = "<SVG>";
    public static final String BIND_NAME_WINDOW = "window";
    public static final String ECMA_WINDOW_INSTANTIATION = "window = new Window(window)";
    private ScriptableObject globalObject = null;
    private LinkedList compiledScripts = new LinkedList();
    private WrapHandler wrapHandler = new EventTargetWrapHandler(this);
    private SecuritySupport securitySupport = new BatikSecuritySupport();
    protected RhinoClassLoader rhinoClassLoader;
    protected Context defaultContext;
    protected Vector contexts = new Vector();
    static /* synthetic */ Class class$org$apache$batik$script$rhino$WindowWrapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RhinoInterpreter(URL documentURL) {
        this.rhinoClassLoader = new RhinoClassLoader(documentURL);
        Context.setCachingEnabled((boolean)false);
        Context.setCachingEnabled((boolean)true);
        Context ctx = this.defaultContext = this.enterContext();
        try {
            ImporterTopLevel importer = new ImporterTopLevel(ctx);
            this.globalObject = importer;
            Object[] p = new NativeJavaPackage[TO_BE_IMPORTED.length];
            int i = 0;
            while (i < TO_BE_IMPORTED.length) {
                p[i] = new NativeJavaPackage(TO_BE_IMPORTED[i]);
                ++i;
            }
            ImporterTopLevel.importPackage((Context)ctx, (Scriptable)this.globalObject, (Object[])p, null);
            ctx.setWrapHandler(this.wrapHandler);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    public AccessControlContext getAccessControlContext() {
        return this.rhinoClassLoader.getAccessControlContext();
    }

    public Context enterContext() {
        Context ctx = Context.enter();
        if (ctx != this.defaultContext && !this.contexts.contains(ctx)) {
            ctx.setSecuritySupport(this.securitySupport);
            this.contexts.add(ctx);
            this.defaultContext = ctx;
        }
        return ctx;
    }

    protected ScriptableObject getGlobalObject() {
        return this.globalObject;
    }

    public Object evaluate(Reader scriptreader) throws InterpreterException, IOException {
        Object rv = null;
        Context ctx = this.enterContext();
        ctx.setWrapHandler(this.wrapHandler);
        try {
            try {
                rv = ctx.evaluateReader((Scriptable)this.globalObject, scriptreader, SOURCE_NAME_SVG, 1, (Object)this.rhinoClassLoader);
            }
            catch (JavaScriptException e) {
                if (e.getValue() instanceof Exception) {
                    Exception ex = (Exception)e.getValue();
                    throw new InterpreterException(ex, ex.getMessage(), -1, -1);
                }
                throw new InterpreterException((Exception)((Object)e), e.getMessage(), -1, -1);
            }
            catch (WrappedException we) {
                throw new InterpreterException((Exception)we.getWrappedException(), we.getWrappedException().getMessage(), -1, -1);
            }
            catch (RuntimeException re) {
                throw new InterpreterException(re, re.getMessage(), -1, -1);
            }
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return rv;
    }

    public Object evaluate(final String scriptstr) throws InterpreterException {
        final Context ctx = this.enterContext();
        ctx.setWrapHandler(this.wrapHandler);
        Script script = null;
        Entry et = null;
        Iterator it = this.compiledScripts.iterator();
        while (it.hasNext()) {
            et = (Entry)it.next();
            if (!et.str.equals(scriptstr)) continue;
            script = et.script;
            it.remove();
            break;
        }
        if (script == null) {
            script = (Script)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return ctx.compileReader((Scriptable)RhinoInterpreter.this.globalObject, (Reader)new StringReader(scriptstr), RhinoInterpreter.SOURCE_NAME_SVG, 1, (Object)RhinoInterpreter.this.rhinoClassLoader);
                    }
                    catch (IOException io) {
                        throw new Error();
                    }
                }
            });
            if (this.compiledScripts.size() + 1 > 32) {
                this.compiledScripts.removeFirst();
            }
            this.compiledScripts.addLast(new Entry(scriptstr, script));
        } else {
            this.compiledScripts.addLast(et);
        }
        Object rv = null;
        try {
            try {
                rv = script.exec(ctx, (Scriptable)this.globalObject);
            }
            catch (JavaScriptException e) {
                if (e.getValue() instanceof Exception) {
                    Exception ex = (Exception)e.getValue();
                    throw new InterpreterException(ex, ex.getMessage(), -1, -1);
                }
                throw new InterpreterException((Exception)((Object)e), e.getMessage(), -1, -1);
            }
            catch (WrappedException we) {
                throw new InterpreterException((Exception)we.getWrappedException(), we.getWrappedException().getMessage(), -1, -1);
            }
            catch (RuntimeException re) {
                throw new InterpreterException(re, re.getMessage(), -1, -1);
            }
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return rv;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindObject(String name, Object object) {
        Context ctx = this.enterContext();
        ctx.setWrapHandler(this.wrapHandler);
        try {
            Scriptable jsObject = Context.toObject((Object)object, (Scriptable)this.globalObject);
            this.globalObject.put(name, (Scriptable)this.globalObject, (Object)jsObject);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        if (name.equals(BIND_NAME_WINDOW) && object instanceof Window) {
            try {
                ScriptableObject.defineClass((Scriptable)this.globalObject, (Class)(class$org$apache$batik$script$rhino$WindowWrapper == null ? (class$org$apache$batik$script$rhino$WindowWrapper = RhinoInterpreter.class$("org.apache.batik.script.rhino.WindowWrapper")) : class$org$apache$batik$script$rhino$WindowWrapper));
                this.evaluate(new StringReader(ECMA_WINDOW_INSTANTIATION));
                this.globalObject = (ScriptableObject)this.globalObject.get(BIND_NAME_WINDOW, (Scriptable)this.globalObject);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callHandler(Function handler, Object arg) throws JavaScriptException {
        Context ctx = this.enterContext();
        ctx.setWrapHandler(this.wrapHandler);
        try {
            arg = Context.toObject((Object)arg, (Scriptable)this.globalObject);
            Object[] args = new Object[]{arg};
            handler.call(ctx, (Scriptable)this.globalObject, (Scriptable)this.globalObject, args);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callHandler(Function handler, Object[] args) throws JavaScriptException {
        Context ctx = this.enterContext();
        ctx.setWrapHandler(this.wrapHandler);
        try {
            handler.call(ctx, (Scriptable)this.globalObject, (Scriptable)this.globalObject, args);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callHandler(Function handler, ArgumentsBuilder ab) throws JavaScriptException {
        Context ctx = this.enterContext();
        ctx.setWrapHandler(this.wrapHandler);
        try {
            handler.call(ctx, (Scriptable)this.globalObject, (Scriptable)this.globalObject, ab.buildArguments());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    Scriptable buildEventTargetWrapper(EventTarget obj) {
        return new EventTargetWrapper((Scriptable)this.globalObject, obj, this);
    }

    public void setOut(Writer out) {
    }

    public Locale getLocale() {
        return null;
    }

    public void setLocale(Locale locale) {
    }

    public String formatMessage(String key, Object[] args) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MAX_CACHED_SCRIPTS = 32;
        SOURCE_NAME_SVG = SOURCE_NAME_SVG;
        BIND_NAME_WINDOW = BIND_NAME_WINDOW;
        ECMA_WINDOW_INSTANTIATION = ECMA_WINDOW_INSTANTIATION;
    }

    public static interface ArgumentsBuilder {
        public Object[] buildArguments();
    }

    private static class Entry {
        String str;
        Script script;

        Entry(String str, Script script) {
            this.str = str;
            this.script = script;
        }
    }
}

