/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JStrategy;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValue;
import org.snmp4j.PDU;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class Snmp4JV2TrapBuilder
implements SnmpTrapBuilder {
    PDU m_pdu;

    Snmp4JV2TrapBuilder(PDU pdu, int type) {
        this.m_pdu = pdu;
        this.m_pdu.setType(type);
    }

    Snmp4JV2TrapBuilder() {
        this(new PDU(), -89);
    }

    protected PDU getPDU() {
        return this.m_pdu;
    }

    public void send(String destAddr, int destPort, String community) throws Exception {
        Snmp4JStrategy.send(destAddr, destPort, community, this.m_pdu);
    }

    public void addVarBind(SnmpObjId name, SnmpValue value) {
        OID oid = new OID(name.getIds());
        Variable val = ((Snmp4JValue)value).getVariable();
        this.m_pdu.add(new VariableBinding(oid, val));
    }

    public void sendTest(String destAddr, int destPort, String community) throws Exception {
        Snmp4JStrategy.sendTest(destAddr, destPort, community, this.m_pdu);
    }
}

