/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.availability;

import java.io.IOException;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.utils.JavaMailer;
import org.opennms.netmgt.utils.JavaMailerException;
import org.opennms.report.availability.AvailabilityReport;

public class ReportMailer {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private Category log;
    private String m_filename;
    private String m_address;

    public ReportMailer() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.log = ThreadCategory.getInstance(AvailabilityReport.class);
    }

    public ReportMailer(String address, String filename) {
        this.m_address = address;
        this.m_filename = filename;
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.log = ThreadCategory.getInstance(AvailabilityReport.class);
    }

    public void send() throws IOException {
        if (this.m_filename == null || this.m_address == null) {
            throw new IllegalArgumentException("Cannot take null paramters.");
        }
        try {
            JavaMailer jm = new JavaMailer();
            jm.setTo(this.m_address);
            jm.setSubject("OpenNMS Availability Report");
            jm.setFileName(this.m_filename);
            jm.setMessageText("Availability Report Mailed from JavaMailer class.");
            jm.mailSend();
        }
        catch (JavaMailerException e) {
            this.log.error((Object)("Caught JavaMailer exception sending file: " + this.m_filename), (Throwable)e);
            throw new IOException("Error sending file: " + this.m_filename);
        }
    }

    public String getAddress() {
        return this.m_address;
    }

    public void setAddress(String address) {
        this.m_address = address;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public void setFilename(String filename) {
        this.m_filename = filename;
    }
}

