/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.availability;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.report.availability.DaysOfWeek;
import org.opennms.report.availability.Week;
import org.xml.sax.ContentHandler;

public class CalendarTable
implements Serializable {
    private String _month;
    private DaysOfWeek _daysOfWeek;
    private ArrayList _weekList = new ArrayList();

    public void addWeek(Week vWeek) throws IndexOutOfBoundsException {
        if (this._weekList.size() >= 6) {
            throw new IndexOutOfBoundsException();
        }
        this._weekList.add(vWeek);
    }

    public void addWeek(int index, Week vWeek) throws IndexOutOfBoundsException {
        if (this._weekList.size() >= 6) {
            throw new IndexOutOfBoundsException();
        }
        this._weekList.add(index, vWeek);
    }

    public void clearWeek() {
        this._weekList.clear();
    }

    public Enumeration enumerateWeek() {
        return new IteratorEnumeration(this._weekList.iterator());
    }

    public DaysOfWeek getDaysOfWeek() {
        return this._daysOfWeek;
    }

    public String getMonth() {
        return this._month;
    }

    public Week getWeek(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._weekList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Week)this._weekList.get(index);
    }

    public Week[] getWeek() {
        int size = this._weekList.size();
        Week[] mArray = new Week[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Week)this._weekList.get(index);
        }
        return mArray;
    }

    public ArrayList getWeekCollection() {
        return this._weekList;
    }

    public int getWeekCount() {
        return this._weekList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeWeek(Week vWeek) {
        boolean removed = this._weekList.remove(vWeek);
        return removed;
    }

    public void setDaysOfWeek(DaysOfWeek daysOfWeek) {
        this._daysOfWeek = daysOfWeek;
    }

    public void setMonth(String month) {
        this._month = month;
    }

    public void setWeek(int index, Week vWeek) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._weekList.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index >= 6) {
            throw new IndexOutOfBoundsException();
        }
        this._weekList.set(index, vWeek);
    }

    public void setWeek(Week[] weekArray) {
        this._weekList.clear();
        for (int i = 0; i < weekArray.length; ++i) {
            this._weekList.add(weekArray[i]);
        }
    }

    public void setWeek(ArrayList weekCollection) {
        this._weekList.clear();
        for (int i = 0; i < weekCollection.size(); ++i) {
            this._weekList.add((Week)weekCollection.get(i));
        }
    }

    public void setWeekCollection(ArrayList weekCollection) {
        this._weekList = weekCollection;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (CalendarTable)Unmarshaller.unmarshal(CalendarTable.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

