/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.availability;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.CatFactory;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.categories.Categorygroup;
import org.opennms.netmgt.config.categories.Catinfo;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.report.availability.AvailCalculations;
import org.opennms.report.availability.CatSections;
import org.opennms.report.availability.Categories;
import org.opennms.report.availability.Category;
import org.opennms.report.availability.Created;
import org.opennms.report.availability.Report;
import org.opennms.report.availability.Section;
import org.opennms.report.availability.ViewInfo;
import org.opennms.report.datablock.Node;
import org.opennms.report.datablock.Outage;
import org.opennms.report.datablock.OutageSvcTimesList;

public class AvailabilityData {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private static final String DEFAULT_FORMAT = "PDF";
    static Connection m_availConn;
    private List m_nodes;
    private String m_commonRule;
    private String m_categoryName;
    private String m_catComment;
    private long m_endTime;
    private long m_12MonthsBack;
    private long m_lastMonthEndTime;
    private int m_daysInLastMonth;
    CatFactory m_catFactory;
    private static long LAST_YEAR_ROLLING_WINDOW;
    private int m_sectionIndex = 0;

    public AvailabilityData(String categoryName, Report report, String monthFormat, Calendar calendar, String startMonth, String startDate, String startYear) throws IOException, MarshalException, ValidationException, Exception {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, Integer.parseInt(startDate));
        cal.set(2, Integer.parseInt(startMonth));
        cal.set(1, Integer.parseInt(startYear));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        this.generateData(categoryName, report, DEFAULT_FORMAT, monthFormat, calendar, new Date(cal.getTimeInMillis()));
    }

    public AvailabilityData(String categoryName, Report report, String format, String monthFormat, Calendar calendar, String startMonth, String startDate, String startYear) throws IOException, MarshalException, ValidationException, Exception {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, Integer.parseInt(startDate));
        cal.set(2, Integer.parseInt(startMonth));
        cal.set(1, Integer.parseInt(startYear));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        this.generateData(categoryName, report, format, monthFormat, calendar, new Date(cal.getTimeInMillis()));
    }

    public AvailabilityData(String categoryName, Report report, String format, String monthFormat, Calendar calendar, Date periodEndDate) throws IOException, MarshalException, ValidationException, Exception {
        this.generateData(categoryName, report, format, monthFormat, calendar, periodEndDate);
    }

    private void generateData(String categoryName, Report report, String format, String monthFormat, Calendar calendar, Date periodEndDate) throws IOException, MarshalException, ValidationException, Exception {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)"Inside AvailabilityData");
        this.m_nodes = new ArrayList();
        this.initializeInterval(calendar, periodEndDate);
        this.m_categoryName = categoryName;
        Catinfo config = null;
        try {
            CategoryFactory.init();
            this.m_catFactory = CategoryFactory.getInstance();
            config = this.m_catFactory.getConfig();
        }
        catch (IOException e) {
            log.fatal((Object)"Initializing CategoryFactory", (Throwable)e);
            throw e;
        }
        catch (MarshalException e) {
            log.fatal((Object)"Initializing CategoryFactory", (Throwable)e);
            throw e;
        }
        catch (ValidationException e) {
            log.fatal((Object)"Initializing CategoryFactory", (Throwable)e);
            throw e;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CATEGORY " + categoryName));
        }
        if (categoryName.equals("") || categoryName.equals("all")) {
            Enumeration enumCG = config.enumerateCategorygroup();
            int catCount = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)("catCount " + catCount));
            }
            while (enumCG.hasMoreElements()) {
                Categorygroup cg = (Categorygroup)enumCG.nextElement();
                org.opennms.netmgt.config.categories.Categories cats = cg.getCategories();
                Enumeration enumCat = cats.enumerateCategory();
                while (enumCat.hasMoreElements()) {
                    org.opennms.netmgt.config.categories.Category cat = (org.opennms.netmgt.config.categories.Category)enumCat.nextElement();
                    Enumeration enumMonitoredSvc = cat.enumerateService();
                    ArrayList<String> monitoredServices = new ArrayList<String>();
                    while (enumMonitoredSvc.hasMoreElements()) {
                        String service = (String)enumMonitoredSvc.nextElement();
                        monitoredServices.add(service);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("CATEGORY " + cat.getLabel()));
                    }
                    this.populateDataStructures(cat, report, format, monthFormat, ++catCount);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("catCount " + catCount));
            }
        } else {
            org.opennms.netmgt.config.categories.Category cat = this.m_catFactory.getCategory(categoryName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("CATEGORY - now populating data structures " + cat.getLabel()));
            }
            this.populateDataStructures(cat, report, format, monthFormat, 1);
        }
        SimpleDateFormat simplePeriod = new SimpleDateFormat("MMMMMMMMMMM dd, yyyy");
        String reportPeriod = simplePeriod.format(new Date(this.m_12MonthsBack)) + " - " + simplePeriod.format(new Date(this.m_endTime));
        Created created = report.getCreated();
        if (created == null) {
            created = new Created();
        }
        created.setPeriod(reportPeriod);
        report.setCreated(created);
        if (log.isDebugEnabled()) {
            log.debug((Object)"After availCalculations");
        }
    }

    private void populateDataStructures(org.opennms.netmgt.config.categories.Category cat, Report report, String format, String monthFormat, int catIndex) throws Exception {
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Inside populate data Structures" + catIndex));
        }
        report.setCatCount(catIndex);
        log.debug((Object)"Inside populate data Structures");
        try {
            String categoryName = cat.getLabel();
            this.m_commonRule = this.m_catFactory.getEffectiveRule(categoryName);
            Enumeration enumMonitoredSvc = cat.enumerateService();
            ArrayList<String> monitoredServices = new ArrayList<String>();
            while (enumMonitoredSvc.hasMoreElements()) {
                String service = (String)enumMonitoredSvc.nextElement();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("adding service" + service));
                }
                monitoredServices.add(service);
            }
            this.populateNodesFromDB(cat, monitoredServices);
            ViewInfo viewInfo = report.getViewInfo();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Nodes " + this.m_nodes));
            }
            ListIterator cleanNodes = this.m_nodes.listIterator();
            while (cleanNodes.hasNext()) {
                Node node = (Node)cleanNodes.next();
                if (node == null || node.hasOutages()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing node: " + node));
                }
                cleanNodes.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cleaned Nodes " + this.m_nodes));
            }
            TreeMap topOffenders = new TreeMap();
            topOffenders = this.getPercentNode();
            if (log.isDebugEnabled()) {
                log.debug((Object)("TOP OFFENDERS " + topOffenders));
            }
            if (this.m_nodes.size() <= 0) {
                this.m_nodes = null;
            }
            if (this.m_nodes != null) {
                AvailCalculations availCalculations = new AvailCalculations(this.m_nodes, this.m_endTime, this.m_lastMonthEndTime, monitoredServices, report, topOffenders, cat.getWarning(), cat.getNormal(), cat.getComment(), cat.getLabel(), format, monthFormat, catIndex, this.m_sectionIndex);
                this.m_sectionIndex = availCalculations.getSectionIndex();
                report.setSectionCount(this.m_sectionIndex - 1);
            } else {
                Category category = new Category();
                category.setCatComments(cat.getComment());
                category.setCatName(cat.getLabel());
                category.setCatIndex(catIndex);
                category.setNodeCount(0);
                category.setIpaddrCount(0);
                category.setServiceCount(0);
                Section section = new Section();
                section.setSectionIndex(this.m_sectionIndex);
                CatSections catSections = new CatSections();
                catSections.addSection(section);
                category.addCatSections(catSections);
                Categories categories = report.getCategories();
                categories.addCategory(category);
                report.setCategories(categories);
                report.setSectionCount(this.m_sectionIndex);
                ++this.m_sectionIndex;
            }
        }
        catch (Exception e) {
            log.fatal((Object)"Exception has occured", (Throwable)e);
            throw e;
        }
    }

    public void initializeInterval(Calendar calendar, Date periodEndDate) {
        GregorianCalendar tempCal = new GregorianCalendar();
        tempCal.setTime(periodEndDate);
        ((Calendar)tempCal).add(5, -1);
        tempCal.set(11, 23);
        tempCal.set(12, 59);
        tempCal.set(13, 59);
        tempCal.set(14, 999);
        this.m_endTime = tempCal.getTimeInMillis();
        ((Calendar)tempCal).add(1, -1);
        tempCal.set(5, 1);
        tempCal.set(11, 0);
        tempCal.set(12, 0);
        tempCal.set(13, 0);
        tempCal.set(14, 0);
        this.m_12MonthsBack = tempCal.getTimeInMillis();
        tempCal.setTimeInMillis(this.m_endTime);
        ((Calendar)tempCal).add(2, -1);
        this.m_daysInLastMonth = ((Calendar)tempCal).getActualMaximum(5);
        tempCal.set(5, this.m_daysInLastMonth);
        tempCal.set(11, 23);
        tempCal.set(12, 59);
        tempCal.set(13, 59);
        tempCal.set(14, 999);
        this.m_lastMonthEndTime = tempCal.getTimeInMillis();
    }

    private void initialiseInterval(Calendar calendar, String startMonth, String startDate, String startYear) {
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        int month = Integer.parseInt(startMonth);
        int day = Integer.parseInt(startDate);
        int year = Integer.parseInt(startYear);
        calendar.set(year, month, day - 1, 23, 59, 59);
        this.m_endTime = calendar.getTime().getTime();
        calendar.add(1, -1);
        LAST_YEAR_ROLLING_WINDOW = this.m_endTime - calendar.getTime().getTime();
        this.m_12MonthsBack = this.m_endTime - LAST_YEAR_ROLLING_WINDOW;
        calendar = new GregorianCalendar();
        calendar.setTime(new Date(this.m_12MonthsBack));
        month = calendar.get(2);
        day = calendar.get(5);
        year = calendar.get(1);
        calendar.set(year, month, 1, 0, 0, 0);
        this.m_12MonthsBack = calendar.getTime().getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("last Year " + new Date(this.m_12MonthsBack)));
            log.debug((Object)("End Year " + new Date(this.m_endTime)));
            log.debug((Object)("Rolling window of the last year " + LAST_YEAR_ROLLING_WINDOW));
        }
        GregorianCalendar lastMonthCalendar = new GregorianCalendar();
        Date lastMonthDate = new Date(new Double(this.m_endTime).longValue());
        lastMonthCalendar.setTime(lastMonthDate);
        month = lastMonthCalendar.get(2) - 1;
        year = lastMonthCalendar.get(1);
        lastMonthCalendar.set(year, month, 1, 0, 0, 0);
        this.m_daysInLastMonth = this.getDaysForMonth(lastMonthCalendar.getTime().getTime());
        lastMonthCalendar.set(year, month, this.m_daysInLastMonth, 23, 59, 59);
        this.m_lastMonthEndTime = lastMonthCalendar.getTime().getTime();
    }

    private static synchronized int getDays(boolean isLeap, int month) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                if (isLeap) {
                    return 29;
                }
                return 28;
            }
        }
        return -1;
    }

    private int getDaysForMonth(long endTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(endTime));
        int month = calendar.get(2);
        int year = calendar.get(1);
        return AvailabilityData.getDays(calendar.isLeapYear(year), month);
    }

    public List getNodes() {
        return this.m_nodes;
    }

    public void initialiseConnection() throws IOException, MarshalException, ValidationException, ClassNotFoundException, SQLException {
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        try {
            DataSourceFactory.init();
            m_availConn = DataSourceFactory.getInstance().getConnection();
        }
        catch (MarshalException e) {
            log.fatal((Object)"initialize: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            log.fatal((Object)"initialize: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            log.fatal((Object)"initialize: Failed to load data collection configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            log.fatal((Object)"initialize: Failed loading database driver.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            log.fatal((Object)"initialize: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            log.fatal((Object)"initialize: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public void closeConnection() {
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        if (m_availConn != null) {
            try {
                m_availConn.close();
                m_availConn = null;
            }
            catch (Throwable t) {
                log.warn((Object)"initialize: an exception occured while closing the JDBC connection", t);
            }
        }
    }

    public TreeMap getPercentNode() {
        org.apache.log4j.Category log = ThreadCategory.getInstance(this.getClass());
        int days = this.m_daysInLastMonth;
        long endTime = this.m_lastMonthEndTime;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(endTime);
        ((Calendar)cal).add(5, -1 * days);
        long rollingWindow = endTime - cal.getTime().getTime();
        long startTime = cal.getTime().getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getPercentNode: Start time " + new Date(startTime)));
            log.debug((Object)("getPercentNode: End time " + new Date(endTime)));
        }
        TreeMap<Double, ArrayList<String>> percentNode = new TreeMap<Double, ArrayList<String>>();
        for (Node node : this.m_nodes) {
            if (node == null) continue;
            double percent = node.getPercentAvail(endTime, rollingWindow);
            String nodeName = node.getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Node " + nodeName + " " + percent + "%"));
            }
            if (!(percent < 100.0)) continue;
            ArrayList<String> tmp = (ArrayList<String>)percentNode.get(new Double(percent));
            if (tmp == null) {
                tmp = new ArrayList<String>();
            }
            tmp.add(nodeName);
            percentNode.put(new Double(percent), tmp);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Percent node " + percentNode));
        }
        return percentNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populateNodesFromDB(org.opennms.netmgt.config.categories.Category cat, List monitoredServices) throws SQLException, FilterParseException, Exception {
        this.m_nodes = new ArrayList();
        org.apache.log4j.Category log = ThreadCategory.getInstance(AvailabilityData.class);
        log.debug((Object)"in populateNodesFromDB");
        this.initialiseConnection();
        PreparedStatement servicesGetStmt = m_availConn.prepareStatement("SELECT ifServices.serviceid, service.servicename FROM ifServices, ipInterface, node, service WHERE ((ifServices.nodeid = ? ) AND (ifServices.ipaddr = ?) AND ipinterface.ipaddr = ? AND ipinterface.isManaged ='M' AND (ifServices.serviceid = service.serviceid) AND (ifservices.status = 'A')) AND node.nodeid = ? AND node.nodetype = 'A'");
        PreparedStatement ipInfoGetStmt = m_availConn.prepareStatement("SELECT  node.nodeid, node.nodelabel FROM node, ipInterface WHERE ((ipInterface.ipaddr = ?) AND (ipInterface.nodeid = node.nodeid) AND (node.nodeType = 'A') AND (ipinterface.ismanaged = 'M') )");
        PreparedStatement outagesGetStmt = m_availConn.prepareStatement("SELECT ifLostService, ifRegainedService from outages where  (outages.nodeid = ?) AND (outages.ipaddr = ?) AND (outages.serviceid = ?)");
        this.m_catComment = cat.getComment();
        String filterRule = this.m_commonRule;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Category: " + filterRule));
        }
        String ip22 = null;
        ResultSet ipRS = null;
        try {
            try {
                List nodeIPs = FilterDaoFactory.getInstance().getIPList(filterRule);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Number of IPs satisfying rule: " + nodeIPs.size()));
                }
                for (String ip22 : nodeIPs) {
                    ipInfoGetStmt.setString(1, ip22);
                    ipRS = ipInfoGetStmt.executeQuery();
                    while (ipRS.next()) {
                        int nodeid = ipRS.getInt(1);
                        String nodeName = ipRS.getString(2);
                        ResultSet svcRS = null;
                        servicesGetStmt.setLong(1, nodeid);
                        servicesGetStmt.setString(2, ip22);
                        servicesGetStmt.setString(3, ip22);
                        servicesGetStmt.setLong(4, nodeid);
                        svcRS = servicesGetStmt.executeQuery();
                        while (svcRS.next()) {
                            int svcid = svcRS.getInt(1);
                            String svcname = svcRS.getString(2);
                            if (!monitoredServices.isEmpty() && !monitoredServices.contains(svcname)) continue;
                            OutageSvcTimesList outageSvcTimesList = new OutageSvcTimesList();
                            this.getOutagesNodeIpSvc(nodeid, nodeName, ip22, svcid, svcname, outageSvcTimesList, outagesGetStmt);
                        }
                        try {
                            if (svcRS == null) continue;
                            svcRS.close();
                        }
                        catch (Exception e) {
                            log.fatal((Object)"Exception while closing the services result set", (Throwable)e);
                            throw e;
                        }
                    }
                }
                Object var19_22 = null;
            }
            catch (SQLException e) {
                log.fatal((Object)("Unable to get node list for category '" + cat.getLabel() + "'"), (Throwable)e);
                throw e;
            }
            catch (FilterParseException e) {
                log.fatal((Object)("Unable to get node list for category '" + cat.getLabel() + "'"), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.fatal((Object)("Unable to get node list for category '" + cat.getLabel() + "'"), (Throwable)e);
                throw new Exception("Unable to get node list for category '" + cat.getLabel() + "': " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            try {
                if (ipRS != null) {
                    ipRS.close();
                }
                if (servicesGetStmt != null) {
                    servicesGetStmt.close();
                }
                if (ipInfoGetStmt != null) {
                    ipInfoGetStmt.close();
                }
                if (outagesGetStmt != null) {
                    outagesGetStmt.close();
                }
                if (m_availConn == null) throw throwable;
                this.closeConnection();
                throw throwable;
            }
            catch (Exception e) {
                log.fatal((Object)("Exception while closing the ip get node info result set.  IP: " + ip22), (Throwable)e);
                throw e;
            }
        }
        try {}
        catch (Exception e) {
            log.fatal((Object)("Exception while closing the ip get node info result set.  IP: " + ip22), (Throwable)e);
            throw e;
        }
        if (ipRS != null) {
            ipRS.close();
        }
        if (servicesGetStmt != null) {
            servicesGetStmt.close();
        }
        if (ipInfoGetStmt != null) {
            ipInfoGetStmt.close();
        }
        if (outagesGetStmt != null) {
            outagesGetStmt.close();
        }
        if (m_availConn == null) return;
        this.closeConnection();
    }

    private void getOutagesNodeIpSvc(int nodeid, String nodeName, String ipaddr, int serviceid, String serviceName, OutageSvcTimesList outageSvcTimesList, PreparedStatement outagesGetStmt) throws SQLException {
        org.apache.log4j.Category log = ThreadCategory.getInstance(AvailabilityData.class);
        try {
            outagesGetStmt.setInt(1, nodeid);
            outagesGetStmt.setString(2, ipaddr);
            outagesGetStmt.setInt(3, serviceid);
            ResultSet rs = outagesGetStmt.executeQuery();
            if (this.m_nodes != null && this.m_nodes.size() > 0) {
                ListIterator lstIter = this.m_nodes.listIterator();
                boolean foundFlag = false;
                Node oldNode = null;
                while (lstIter.hasNext()) {
                    oldNode = (Node)lstIter.next();
                    if (oldNode == null || oldNode.getNodeID() != nodeid) continue;
                    foundFlag = true;
                    break;
                }
                if (!foundFlag) {
                    Node newNode = new Node(nodeName, nodeid);
                    newNode.addInterface(ipaddr, serviceName);
                    this.m_nodes.add(newNode);
                } else {
                    oldNode.addInterface(ipaddr, serviceName);
                }
            } else {
                Node newNode = new Node(nodeName, nodeid);
                newNode.addInterface(ipaddr, serviceName);
                this.m_nodes.add(newNode);
            }
            while (rs.next()) {
                Timestamp lost = rs.getTimestamp(1);
                Timestamp regained = rs.getTimestamp(2);
                long losttime = lost.getTime();
                long regainedtime = 0L;
                if (regained != null) {
                    regainedtime = regained.getTime();
                }
                if (regainedtime > 0L ? regainedtime <= this.m_12MonthsBack || losttime >= this.m_endTime : losttime >= this.m_endTime) continue;
                Outage outage = new Outage(losttime, regainedtime);
                outageSvcTimesList.add(outage);
                this.addNode(nodeName, nodeid, ipaddr, serviceName, losttime, regainedtime);
            }
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.fatal((Object)"Error has occured while getting the outages ", (Throwable)e);
            throw e;
        }
    }

    public void addNode(String nodeName, int nodeid, String ipaddr, String serviceid, long losttime, long regainedtime) {
        if (this.m_nodes != null) {
            if (this.m_nodes.size() <= 0) {
                Node newNode = new Node(nodeName, nodeid);
                if (losttime > 0L) {
                    if (regainedtime > 0L) {
                        newNode.addInterface(ipaddr, serviceid, losttime, regainedtime);
                    } else {
                        newNode.addInterface(ipaddr, serviceid, losttime);
                    }
                } else {
                    newNode.addInterface(ipaddr, serviceid);
                }
                this.m_nodes.add(newNode);
                return;
            }
            Node newNode = null;
            boolean foundFlag = false;
            ListIterator lstIter = this.m_nodes.listIterator();
            while (lstIter.hasNext()) {
                newNode = (Node)lstIter.next();
                if (newNode.getNodeID() != nodeid) continue;
                foundFlag = true;
                break;
            }
            if (!foundFlag) {
                newNode = new Node(nodeName, nodeid);
                if (losttime > 0L) {
                    if (regainedtime > 0L) {
                        newNode.addInterface(ipaddr, serviceid, losttime, regainedtime);
                    } else {
                        newNode.addInterface(ipaddr, serviceid, losttime);
                    }
                } else {
                    newNode.addInterface(ipaddr, serviceid);
                }
                this.m_nodes.add(newNode);
                return;
            }
            if (losttime > 0L) {
                if (regainedtime > 0L) {
                    newNode.addInterface(ipaddr, serviceid, losttime, regainedtime);
                } else {
                    newNode.addInterface(ipaddr, serviceid, losttime);
                }
            } else {
                newNode.addInterface(ipaddr, serviceid);
            }
            return;
        }
        this.m_nodes = new ArrayList();
    }
}

