/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.report.availability;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.AvailabilityReportLocator;
import org.opennms.report.availability.AvailabilityCalculationException;
import org.opennms.report.availability.AvailabilityData;
import org.opennms.report.availability.AvailabilityReportLocatorService;
import org.opennms.report.availability.Categories;
import org.opennms.report.availability.Created;
import org.opennms.report.availability.Report;
import org.opennms.report.availability.ViewInfo;

public class AvailabilityCalculator {
    private static final String LOG4J_CATEGORY = "OpenNMS.Report";
    private static final String XML_FORMAT = "xml";
    public static String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private Calendar m_calendar;
    private Date m_periodEndDate;
    private String m_monthFormat;
    private String m_reportFormat;
    private String m_logoURL;
    private String m_baseDir;
    private String m_outputFileName;
    private String m_author;
    private String m_categoryName;
    private Report m_report = null;
    private Category log;
    private AvailabilityReportLocatorService m_locatorService;

    public AvailabilityCalculator() {
        ThreadCategory.setPrefix((String)LOG4J_CATEGORY);
        this.log = ThreadCategory.getInstance(this.getClass());
        this.m_report = new Report();
        this.m_report.setAuthor(this.m_author);
        GregorianCalendar today = new GregorianCalendar();
        int day = today.get(5);
        int year = today.get(1);
        String month = months[today.get(2)];
        int hour = today.get(10);
        int minute = today.get(12);
        int second = today.get(13);
        Created created = new Created();
        created.setDay(day);
        created.setHour(hour);
        created.setMin(minute);
        created.setMonth(month);
        created.setSec(second);
        created.setYear(year);
        created.setContent(today.getTime().getTime());
        this.m_report.setCreated(created);
    }

    public void calculate() throws AvailabilityCalculationException {
        this.log.debug((Object)"Calculation Started");
        this.log.debug((Object)("periodEndDate: " + this.m_periodEndDate));
        this.m_report.setLogo(this.m_logoURL);
        ViewInfo viewInfo = new ViewInfo();
        this.m_report.setViewInfo(viewInfo);
        Categories categories = new Categories();
        this.m_report.setCategories(categories);
        try {
            this.log.debug((Object)"Populating datastructures and calculating availabilty");
            this.log.debug((Object)("category:     " + this.m_categoryName));
            this.log.debug((Object)("monthFormat:  " + this.m_monthFormat));
            this.log.debug((Object)("reportFormat: " + this.m_reportFormat));
            AvailabilityData availData = new AvailabilityData(this.m_categoryName, this.m_report, this.m_reportFormat, this.m_monthFormat, this.m_calendar, this.m_periodEndDate);
        }
        catch (MarshalException me) {
            this.log.fatal((Object)"MarshalException ", (Throwable)me);
            throw new AvailabilityCalculationException(me);
        }
        catch (ValidationException ve) {
            this.log.fatal((Object)"Validation Exception ", (Throwable)ve);
            throw new AvailabilityCalculationException(ve);
        }
        catch (IOException ioe) {
            this.log.fatal((Object)"Validation Exception ", (Throwable)ioe);
            throw new AvailabilityCalculationException(ioe);
        }
        catch (Exception e) {
            this.log.fatal((Object)"Exception ", (Throwable)e);
            throw new AvailabilityCalculationException(e);
        }
    }

    public void writeXML() throws AvailabilityCalculationException {
        try {
            this.log.debug((Object)"Writing the XML");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
            String catFileName = this.m_categoryName.replace(' ', '-');
            this.m_outputFileName = catFileName + "-" + this.m_monthFormat + fmt.format(this.m_periodEndDate) + ".xml";
            this.log.debug((Object)("Report Store XML file: " + this.m_outputFileName));
            File reportFile = new File(this.m_baseDir, this.m_outputFileName);
            this.marshal(reportFile);
        }
        catch (AvailabilityCalculationException e) {
            this.log.fatal((Object)"Unable to marshal report as XML");
            throw new AvailabilityCalculationException(e);
        }
    }

    public void writeXML(String outputFileName) throws AvailabilityCalculationException {
        try {
            this.log.debug((Object)"Writing the XML");
            this.m_outputFileName = outputFileName;
            this.log.debug((Object)("Report Store XML file: " + this.m_outputFileName));
            File reportFile = new File(this.m_baseDir, this.m_outputFileName);
            this.marshal(reportFile);
        }
        catch (AvailabilityCalculationException e) {
            this.log.fatal((Object)"Unable to marshal report as XML");
            throw new AvailabilityCalculationException(e);
        }
    }

    public void writeLocateableXML() throws AvailabilityCalculationException {
        try {
            this.log.debug((Object)"Writing the XML");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
            String catFileName = this.m_categoryName.replace(' ', '-');
            this.m_outputFileName = catFileName + "-" + this.m_monthFormat + fmt.format(this.m_periodEndDate) + ".xml";
            this.log.debug((Object)("Report Store XML file: " + this.m_outputFileName));
            File reportFile = new File(this.m_baseDir, this.m_outputFileName);
            this.marshal(reportFile);
            AvailabilityReportLocator locator = new AvailabilityReportLocator();
            locator.setCategory(this.m_categoryName);
            locator.setDate(this.m_periodEndDate);
            locator.setType(this.m_monthFormat);
            locator.setFormat(XML_FORMAT);
            locator.setLocation(reportFile.getAbsolutePath());
            locator.setAvailable(Boolean.valueOf(true));
            this.m_locatorService.addReport(locator);
        }
        catch (AvailabilityCalculationException e) {
            this.log.fatal((Object)"Unable to marshal report as XML");
            throw new AvailabilityCalculationException(e);
        }
    }

    public void marshal(File outputFile) throws AvailabilityCalculationException {
        try {
            FileWriter fileWriter = new FileWriter(outputFile);
            Marshaller marshaller = new Marshaller((Writer)fileWriter);
            marshaller.setSuppressNamespaces(true);
            marshaller.marshal((Object)this.m_report);
            this.log.debug((Object)("The xml marshalled from the castor classes is saved in " + outputFile.getAbsoluteFile()));
            fileWriter.close();
        }
        catch (MarshalException me) {
            this.log.fatal((Object)"MarshalException ", (Throwable)me);
            throw new AvailabilityCalculationException(me);
        }
        catch (ValidationException ve) {
            this.log.fatal((Object)"Validation Exception ", (Throwable)ve);
            throw new AvailabilityCalculationException(ve);
        }
        catch (IOException ioe) {
            this.log.fatal((Object)"IO Exception ", (Throwable)ioe);
            throw new AvailabilityCalculationException(ioe);
        }
    }

    public String getLogoURL() {
        return this.m_logoURL;
    }

    public void setLogoURL(String logoURL) {
        this.m_logoURL = logoURL;
    }

    public String getOutputFileName() {
        return this.m_outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.m_outputFileName = outputFileName;
    }

    public String getAuthor() {
        return this.m_author;
    }

    public void setAuthor(String author) {
        this.m_author = author;
    }

    public String getCategoryName() {
        return this.m_categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.m_categoryName = categoryName;
    }

    public String getMonthFormat() {
        return this.m_monthFormat;
    }

    public void setMonthFormat(String monthFormat) {
        this.m_monthFormat = monthFormat;
    }

    public String getReportFormat() {
        return this.m_reportFormat;
    }

    public void setReportFormat(String reportFormat) {
        this.m_reportFormat = reportFormat;
    }

    public Report getReport() {
        return this.m_report;
    }

    public void setCalendar(Calendar calendar) {
        this.m_calendar = calendar;
    }

    public Date getPeriodEndDate() {
        return this.m_periodEndDate;
    }

    public void setPeriodEndDate(Date periodEndDate) {
        this.m_periodEndDate = periodEndDate;
    }

    public AvailabilityReportLocatorService getLocatorService() {
        return this.m_locatorService;
    }

    public void setLocatorService(AvailabilityReportLocatorService locatorService) {
        this.m_locatorService = locatorService;
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.m_baseDir = baseDir;
    }
}

