/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools.config;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.correlation.drools.config.Global;
import org.xml.sax.ContentHandler;

public class RuleSet
implements Serializable {
    private String _name;
    private ArrayList _ruleFileList = new ArrayList();
    private ArrayList _eventList = new ArrayList();
    private String _appContext;
    private ArrayList _globalList = new ArrayList();

    public void addEvent(String vEvent) throws IndexOutOfBoundsException {
        this._eventList.add(vEvent);
    }

    public void addEvent(int index, String vEvent) throws IndexOutOfBoundsException {
        this._eventList.add(index, vEvent);
    }

    public void addGlobal(Global vGlobal) throws IndexOutOfBoundsException {
        this._globalList.add(vGlobal);
    }

    public void addGlobal(int index, Global vGlobal) throws IndexOutOfBoundsException {
        this._globalList.add(index, vGlobal);
    }

    public void addRuleFile(String vRuleFile) throws IndexOutOfBoundsException {
        this._ruleFileList.add(vRuleFile);
    }

    public void addRuleFile(int index, String vRuleFile) throws IndexOutOfBoundsException {
        this._ruleFileList.add(index, vRuleFile);
    }

    public void clearEvent() {
        this._eventList.clear();
    }

    public void clearGlobal() {
        this._globalList.clear();
    }

    public void clearRuleFile() {
        this._ruleFileList.clear();
    }

    public Enumeration enumerateEvent() {
        return new IteratorEnumeration(this._eventList.iterator());
    }

    public Enumeration enumerateGlobal() {
        return new IteratorEnumeration(this._globalList.iterator());
    }

    public Enumeration enumerateRuleFile() {
        return new IteratorEnumeration(this._ruleFileList.iterator());
    }

    public String getAppContext() {
        return this._appContext;
    }

    public String getEvent(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._eventList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this._eventList.get(index);
    }

    public String[] getEvent() {
        int size = this._eventList.size();
        String[] mArray = new String[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (String)this._eventList.get(index);
        }
        return mArray;
    }

    public ArrayList getEventCollection() {
        return this._eventList;
    }

    public int getEventCount() {
        return this._eventList.size();
    }

    public Global getGlobal(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._globalList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Global)this._globalList.get(index);
    }

    public Global[] getGlobal() {
        int size = this._globalList.size();
        Global[] mArray = new Global[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Global)this._globalList.get(index);
        }
        return mArray;
    }

    public ArrayList getGlobalCollection() {
        return this._globalList;
    }

    public int getGlobalCount() {
        return this._globalList.size();
    }

    public String getName() {
        return this._name;
    }

    public String getRuleFile(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._ruleFileList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this._ruleFileList.get(index);
    }

    public String[] getRuleFile() {
        int size = this._ruleFileList.size();
        String[] mArray = new String[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (String)this._ruleFileList.get(index);
        }
        return mArray;
    }

    public ArrayList getRuleFileCollection() {
        return this._ruleFileList;
    }

    public int getRuleFileCount() {
        return this._ruleFileList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeEvent(String vEvent) {
        boolean removed = this._eventList.remove(vEvent);
        return removed;
    }

    public boolean removeGlobal(Global vGlobal) {
        boolean removed = this._globalList.remove(vGlobal);
        return removed;
    }

    public boolean removeRuleFile(String vRuleFile) {
        boolean removed = this._ruleFileList.remove(vRuleFile);
        return removed;
    }

    public void setAppContext(String appContext) {
        this._appContext = appContext;
    }

    public void setEvent(int index, String vEvent) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._eventList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._eventList.set(index, vEvent);
    }

    public void setEvent(String[] eventArray) {
        this._eventList.clear();
        for (int i = 0; i < eventArray.length; ++i) {
            this._eventList.add(eventArray[i]);
        }
    }

    public void setEvent(ArrayList eventCollection) {
        this._eventList.clear();
        for (int i = 0; i < eventCollection.size(); ++i) {
            this._eventList.add((String)eventCollection.get(i));
        }
    }

    public void setEventCollection(ArrayList eventCollection) {
        this._eventList = eventCollection;
    }

    public void setGlobal(int index, Global vGlobal) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._globalList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._globalList.set(index, vGlobal);
    }

    public void setGlobal(Global[] globalArray) {
        this._globalList.clear();
        for (int i = 0; i < globalArray.length; ++i) {
            this._globalList.add(globalArray[i]);
        }
    }

    public void setGlobal(ArrayList globalCollection) {
        this._globalList.clear();
        for (int i = 0; i < globalCollection.size(); ++i) {
            this._globalList.add((Global)globalCollection.get(i));
        }
    }

    public void setGlobalCollection(ArrayList globalCollection) {
        this._globalList = globalCollection;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRuleFile(int index, String vRuleFile) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._ruleFileList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._ruleFileList.set(index, vRuleFile);
    }

    public void setRuleFile(String[] ruleFileArray) {
        this._ruleFileList.clear();
        for (int i = 0; i < ruleFileArray.length; ++i) {
            this._ruleFileList.add(ruleFileArray[i]);
        }
    }

    public void setRuleFile(ArrayList ruleFileCollection) {
        this._ruleFileList.clear();
        for (int i = 0; i < ruleFileCollection.size(); ++i) {
            this._ruleFileList.add((String)ruleFileCollection.get(i));
        }
    }

    public void setRuleFileCollection(ArrayList ruleFileCollection) {
        this._ruleFileList = ruleFileCollection;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (RuleSet)Unmarshaller.unmarshal(RuleSet.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

