/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.drools.config;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.correlation.drools.config.RuleSet;
import org.xml.sax.ContentHandler;

public class EngineConfiguration
implements Serializable {
    private ArrayList _ruleSetList = new ArrayList();

    public void addRuleSet(RuleSet vRuleSet) throws IndexOutOfBoundsException {
        this._ruleSetList.add(vRuleSet);
    }

    public void addRuleSet(int index, RuleSet vRuleSet) throws IndexOutOfBoundsException {
        this._ruleSetList.add(index, vRuleSet);
    }

    public void clearRuleSet() {
        this._ruleSetList.clear();
    }

    public Enumeration enumerateRuleSet() {
        return new IteratorEnumeration(this._ruleSetList.iterator());
    }

    public RuleSet getRuleSet(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._ruleSetList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (RuleSet)this._ruleSetList.get(index);
    }

    public RuleSet[] getRuleSet() {
        int size = this._ruleSetList.size();
        RuleSet[] mArray = new RuleSet[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (RuleSet)this._ruleSetList.get(index);
        }
        return mArray;
    }

    public ArrayList getRuleSetCollection() {
        return this._ruleSetList;
    }

    public int getRuleSetCount() {
        return this._ruleSetList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeRuleSet(RuleSet vRuleSet) {
        boolean removed = this._ruleSetList.remove(vRuleSet);
        return removed;
    }

    public void setRuleSet(int index, RuleSet vRuleSet) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._ruleSetList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._ruleSetList.set(index, vRuleSet);
    }

    public void setRuleSet(RuleSet[] ruleSetArray) {
        this._ruleSetList.clear();
        for (int i = 0; i < ruleSetArray.length; ++i) {
            this._ruleSetList.add(ruleSetArray[i]);
        }
    }

    public void setRuleSet(ArrayList ruleSetCollection) {
        this._ruleSetList.clear();
        for (int i = 0; i < ruleSetCollection.size(); ++i) {
            this._ruleSetList.add((RuleSet)ruleSetCollection.get(i));
        }
    }

    public void setRuleSetCollection(ArrayList ruleSetCollection) {
        this._ruleSetList = ruleSetCollection;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (EngineConfiguration)Unmarshaller.unmarshal(EngineConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

