/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.log;

import com.mchange.v1.util.StringTokenizerUtils;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.FallbackMLog;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogClasses;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.log.NameTransformer;

public abstract class MLog {
    static final NameTransformer transformer;
    static final MLog mlog;
    static final MultiPropertiesConfig CONFIG;

    public static MLog findByClassnames(String[] classnames) {
        int len = classnames.length;
        for (int i = 0; i < len; ++i) {
            try {
                return (MLog)Class.forName(classnames[i]).newInstance();
            }
            catch (Exception e) {
                System.err.println("com.mchange.v2.log.MLog '" + classnames[i] + "' could not be loaded!");
                e.printStackTrace();
                continue;
            }
        }
        return null;
    }

    public static MLog instance() {
        return mlog;
    }

    public static MLogger getLogger(String name) {
        String xname;
        MLogger out = transformer == null ? MLog.instance().getMLogger(name) : ((xname = transformer.transformName(name)) != null ? MLog.instance().getMLogger(xname) : MLog.instance().getMLogger(name));
        return out;
    }

    public static MLogger getLogger(Class cl) {
        String xname;
        MLogger out = transformer == null ? MLog.instance().getMLogger(cl) : ((xname = transformer.transformName(cl)) != null ? MLog.instance().getMLogger(xname) : MLog.instance().getMLogger(cl));
        return out;
    }

    public static MLogger getLogger() {
        String xname;
        MLogger out = transformer == null ? MLog.instance().getMLogger() : ((xname = transformer.transformName()) != null ? MLog.instance().getMLogger(xname) : MLog.instance().getMLogger());
        return out;
    }

    public static void log(MLevel l, String msg) {
        MLog.instance();
        MLog.getLogger().log(l, msg);
    }

    public static void log(MLevel l, String msg, Object param) {
        MLog.instance();
        MLog.getLogger().log(l, msg, param);
    }

    public static void log(MLevel l, String msg, Object[] params) {
        MLog.instance();
        MLog.getLogger().log(l, msg, params);
    }

    public static void log(MLevel l, String msg, Throwable t) {
        MLog.instance();
        MLog.getLogger().log(l, msg, t);
    }

    public static void logp(MLevel l, String srcClass, String srcMeth, String msg) {
        MLog.instance();
        MLog.getLogger().logp(l, srcClass, srcMeth, msg);
    }

    public static void logp(MLevel l, String srcClass, String srcMeth, String msg, Object param) {
        MLog.instance();
        MLog.getLogger().logp(l, srcClass, srcMeth, msg, param);
    }

    public static void logp(MLevel l, String srcClass, String srcMeth, String msg, Object[] params) {
        MLog.instance();
        MLog.getLogger().logp(l, srcClass, srcMeth, msg, params);
    }

    public static void logp(MLevel l, String srcClass, String srcMeth, String msg, Throwable t) {
        MLog.instance();
        MLog.getLogger().logp(l, srcClass, srcMeth, msg, t);
    }

    public static void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg) {
        MLog.instance();
        MLog.getLogger().logp(l, srcClass, srcMeth, rb, msg);
    }

    public static void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object param) {
        MLog.instance();
        MLog.getLogger().logrb(l, srcClass, srcMeth, rb, msg, param);
    }

    public static void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Object[] params) {
        MLog.instance();
        MLog.getLogger().logrb(l, srcClass, srcMeth, rb, msg, params);
    }

    public static void logrb(MLevel l, String srcClass, String srcMeth, String rb, String msg, Throwable t) {
        MLog.instance();
        MLog.getLogger().logrb(l, srcClass, srcMeth, rb, msg, t);
    }

    public static void entering(String srcClass, String srcMeth) {
        MLog.instance();
        MLog.getLogger().entering(srcClass, srcMeth);
    }

    public static void entering(String srcClass, String srcMeth, Object param) {
        MLog.instance();
        MLog.getLogger().entering(srcClass, srcMeth, param);
    }

    public static void entering(String srcClass, String srcMeth, Object[] params) {
        MLog.instance();
        MLog.getLogger().entering(srcClass, srcMeth, params);
    }

    public static void exiting(String srcClass, String srcMeth) {
        MLog.instance();
        MLog.getLogger().exiting(srcClass, srcMeth);
    }

    public static void exiting(String srcClass, String srcMeth, Object result) {
        MLog.instance();
        MLog.getLogger().exiting(srcClass, srcMeth, result);
    }

    public static void throwing(String srcClass, String srcMeth, Throwable t) {
        MLog.instance();
        MLog.getLogger().throwing(srcClass, srcMeth, t);
    }

    public static void severe(String msg) {
        MLog.instance();
        MLog.getLogger().severe(msg);
    }

    public static void warning(String msg) {
        MLog.instance();
        MLog.getLogger().warning(msg);
    }

    public static void info(String msg) {
        MLog.instance();
        MLog.getLogger().info(msg);
    }

    public static void config(String msg) {
        MLog.instance();
        MLog.getLogger().config(msg);
    }

    public static void fine(String msg) {
        MLog.instance();
        MLog.getLogger().fine(msg);
    }

    public static void finer(String msg) {
        MLog.instance();
        MLog.getLogger().finer(msg);
    }

    public static void finest(String msg) {
        MLog.instance();
        MLog.getLogger().finest(msg);
    }

    public abstract MLogger getMLogger(String var1);

    public abstract MLogger getMLogger(Class var1);

    public abstract MLogger getMLogger();

    static {
        String[] defaults = new String[]{"/com/mchange/v2/log/default-mchange-log.properties", "/mchange-log.properties", "/"};
        CONFIG = MultiPropertiesConfig.readVmConfig(defaults, null);
        String classnamesStr = CONFIG.getProperty("com.mchange.v2.log.MLog");
        String[] classnames = null;
        if (classnamesStr == null) {
            classnamesStr = CONFIG.getProperty("com.mchange.v2.log.mlog");
        }
        if (classnamesStr != null) {
            classnames = StringTokenizerUtils.tokenizeToArray(classnamesStr, ", \t\r\n");
        }
        boolean warn = false;
        MLog tmpml = null;
        if (classnames != null) {
            tmpml = MLog.findByClassnames(classnames);
        }
        if (tmpml == null) {
            tmpml = MLog.findByClassnames(MLogClasses.CLASSNAMES);
        }
        if (tmpml == null) {
            warn = true;
            tmpml = new FallbackMLog();
        }
        mlog = tmpml;
        if (warn) {
            MLog.info("Using " + mlog.getClass().getName() + " -- Named logger's not supported, everything goes to System.err.");
        }
        NameTransformer tmpt = null;
        String tClassName = CONFIG.getProperty("com.mchange.v2.log.NameTransformer");
        if (tClassName == null) {
            tClassName = CONFIG.getProperty("com.mchange.v2.log.nametransformer");
        }
        try {
            if (tClassName != null) {
                tmpt = (NameTransformer)Class.forName(tClassName).newInstance();
            }
        }
        catch (Exception e) {
            System.err.println("Failed to instantiate com.mchange.v2.log.NameTransformer '" + tClassName + "'!");
            e.printStackTrace();
        }
        transformer = tmpt;
    }
}

