/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;

public final class C3P0ImplUtils {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$impl$C3P0ImplUtils == null ? (class$com$mchange$v2$c3p0$impl$C3P0ImplUtils = C3P0ImplUtils.class$("com.mchange.v2.c3p0.impl.C3P0ImplUtils")) : class$com$mchange$v2$c3p0$impl$C3P0ImplUtils);
    public static final DbAuth NULL_AUTH = new DbAuth(null, null);
    public static final Object[] NOARGS = new Object[0];
    static String connectionTesterClassName = null;
    static ConnectionTester cachedTester = null;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0ImplUtils;
    static /* synthetic */ Class class$java$lang$String;

    public static String identityToken(Object o) {
        return o != null ? Integer.toString(System.identityHashCode(o), 16) : null;
    }

    public static DbAuth findAuth(Object o) throws SQLException {
        if (o == null) {
            return NULL_AUTH;
        }
        String user = null;
        String password = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(o.getClass());
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            int len = pds.length;
            for (int i = 0; i < len; ++i) {
                Method readMethod;
                PropertyDescriptor pd = pds[i];
                Class<?> propCl = pd.getPropertyType();
                String propName = pd.getName();
                if (propCl != (class$java$lang$String == null ? C3P0ImplUtils.class$("java.lang.String") : class$java$lang$String) || (readMethod = pd.getReadMethod()) == null) continue;
                Object propVal = readMethod.invoke(o, NOARGS);
                String value = (String)propVal;
                if ("user".equals(propName)) {
                    user = value;
                    continue;
                }
                if (!"password".equals(propName)) continue;
                password = value;
            }
            if (user == null) {
                return NULL_AUTH;
            }
            return new DbAuth(user, password);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "An exception occurred while trying to extract the default authentification info from a bean.", e);
            }
            throw SqlUtils.toSQLException(e);
        }
    }

    static void resetTxnState(Connection pCon, boolean forceIgnoreUnresolvedTransactions, boolean autoCommitOnClose, boolean txnKnownResolved) throws SQLException {
        if (!forceIgnoreUnresolvedTransactions && !pCon.getAutoCommit()) {
            if (!autoCommitOnClose && !txnKnownResolved) {
                pCon.rollback();
            }
            pCon.setAutoCommit(true);
        }
    }

    public static synchronized ConnectionTester defaultConnectionTester() {
        String dfltCxnTesterClassName = PoolConfig.defaultConnectionTesterClassName();
        if (connectionTesterClassName != null && connectionTesterClassName.equals(dfltCxnTesterClassName)) {
            return cachedTester;
        }
        try {
            cachedTester = (ConnectionTester)Class.forName(dfltCxnTesterClassName).newInstance();
            connectionTesterClassName = cachedTester.getClass().getName();
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Could not load ConnectionTester " + dfltCxnTesterClassName + ", using built in default.", e);
            }
            cachedTester = C3P0Defaults.connectionTester();
            connectionTesterClassName = cachedTester.getClass().getName();
        }
        return cachedTester;
    }

    private C3P0ImplUtils() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

