/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpUtil;
import org.opennms.protocols.snmp.SnmpVarBind;
import org.opennms.protocols.snmp.asn1.AsnDecodingException;
import org.opennms.protocols.snmp.asn1.AsnEncoder;
import org.opennms.protocols.snmp.asn1.AsnEncodingException;

public abstract class SnmpPduPacket
implements SnmpSyntax,
Cloneable {
    private static int sm_seq = 0;
    private int m_command;
    private int m_requestId;
    private SnmpPeer m_peer = null;
    private ArrayList m_variables;
    protected int m_errStatus;
    protected int m_errIndex;
    public static final int GET = 160;
    public static final int GETNEXT = 161;
    public static final int RESPONSE = 162;
    public static final int SET = 163;
    public static final int GETBULK = 165;
    public static final int INFORM = 166;
    public static final int V2TRAP = 167;
    public static final int REPORT = 168;
    public static final int ErrNoError = 0;
    public static final int ErrTooBig = 1;
    public static final int ErrNoSuchName = 2;
    public static final int ErrBadValue = 3;
    public static final int ErrReadOnly = 4;
    public static final int ErrGenError = 5;
    public static final int ErrNoAccess = 6;
    public static final int ErrWrongType = 7;
    public static final int ErrWrongLength = 8;
    public static final int ErrWrongEncoding = 9;
    public static final int ErrWrongValue = 10;
    public static final int ErrNoCreation = 11;
    public static final int ErrInconsistentValue = 12;
    public static final int ErrResourceUnavailable = 13;
    public static final int ErrCommitFailed = 14;
    public static final int ErrUndoFailed = 15;
    public static final int ErrAuthorizationError = 16;
    public static final int ErrNotWritable = 17;
    public static final int ErrInconsistentName = 18;

    protected SnmpPduPacket() {
        this.m_command = 0;
        this.m_requestId = 0;
        this.m_errStatus = 0;
        this.m_errIndex = 0;
        this.m_variables = new ArrayList();
    }

    protected SnmpPduPacket(SnmpPduPacket second) {
        this.m_command = second.m_command;
        this.m_requestId = second.m_requestId;
        this.m_errStatus = second.m_errStatus;
        this.m_errIndex = second.m_errIndex;
        int sz = second.m_variables.size();
        this.m_variables = new ArrayList(sz);
        for (int x = 0; x < sz; ++x) {
            this.m_variables.add(x, ((SnmpVarBind)second.m_variables.get(x)).duplicate());
        }
    }

    protected SnmpPduPacket(int command) {
        this();
        this.m_command = command;
    }

    protected SnmpPduPacket(int command, SnmpVarBind[] vars) {
        this(command);
        if (vars != null) {
            this.m_variables.ensureCapacity(vars.length);
            for (int x = 0; x < vars.length; ++x) {
                this.m_variables.add(vars[x].duplicate());
            }
        }
    }

    public static synchronized int nextSequence() {
        if (sm_seq == 0) {
            Date seed = new Date();
            Random rnd = new Random(seed.getTime());
            sm_seq = rnd.nextInt(1000000);
        }
        return sm_seq++;
    }

    public int getCommand() {
        return this.m_command;
    }

    public void setCommand(int cmd) {
        this.m_command = cmd;
    }

    public int getRequestId() {
        return this.m_requestId;
    }

    public void setPeer(SnmpPeer peer) {
        this.m_peer = peer;
    }

    public SnmpPeer getPeer() {
        return this.m_peer;
    }

    public void setRequestId(int reqid) {
        this.m_requestId = reqid;
    }

    public int getLength() {
        return this.m_variables.size();
    }

    public void addVarBind(SnmpVarBind vb) {
        this.m_variables.add(vb);
    }

    public void addVarBindAt(int ndx, SnmpVarBind vb) {
        this.m_variables.add(ndx, vb);
    }

    public SnmpVarBind getVarBindAt(int ndx) {
        return (SnmpVarBind)this.m_variables.get(ndx);
    }

    public void setVarBindAt(int ndx, SnmpVarBind vb) {
        this.m_variables.set(ndx, vb);
    }

    public SnmpVarBind removeVarBindAt(int ndx) {
        return (SnmpVarBind)this.m_variables.remove(ndx);
    }

    public SnmpVarBind[] toVarBindArray() {
        Object[] list = this.m_variables.toArray();
        SnmpVarBind[] vblist = new SnmpVarBind[list.length];
        for (int x = 0; x < list.length; ++x) {
            vblist[x] = (SnmpVarBind)list[x];
        }
        return vblist;
    }

    public byte typeId() {
        return (byte)(this.m_command & 0xFF);
    }

    public int encodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnEncodingException {
        int begin = offset;
        SnmpInt32 val = new SnmpInt32(this.m_requestId);
        offset = val.encodeASN(buf, offset, encoder);
        val.setValue(this.m_errStatus);
        offset = val.encodeASN(buf, offset, encoder);
        val.setValue(this.m_errIndex);
        int vbbegin = offset = val.encodeASN(buf, offset, encoder);
        int sz = this.m_variables.size();
        for (int x = 0; x < sz; ++x) {
            SnmpVarBind ref = (SnmpVarBind)this.m_variables.get(x);
            offset = ref.encodeASN(buf, offset, encoder);
        }
        int pivot = offset;
        offset = encoder.buildHeader(buf, offset, (byte)48, pivot - vbbegin);
        SnmpUtil.rotate(buf, vbbegin, pivot, offset);
        pivot = offset;
        offset = encoder.buildHeader(buf, offset, this.typeId(), pivot - begin);
        SnmpUtil.rotate(buf, begin, pivot, offset);
        return offset;
    }

    public int decodeASN(byte[] buf, int offset, AsnEncoder encoder) throws AsnDecodingException {
        Object[] rVals = encoder.parseHeader(buf, offset);
        offset = (Integer)rVals[0];
        int cmd = ((Byte)rVals[1]).intValue();
        int length = (Integer)rVals[2];
        int begin = offset;
        if (cmd < 0) {
            cmd += 256;
        }
        this.m_command = cmd;
        SnmpInt32 val = new SnmpInt32();
        offset = val.decodeASN(buf, offset, encoder);
        this.m_requestId = val.getValue();
        offset = val.decodeASN(buf, offset, encoder);
        this.m_errStatus = val.getValue();
        offset = val.decodeASN(buf, offset, encoder);
        this.m_errIndex = val.getValue();
        rVals = encoder.parseHeader(buf, offset);
        offset = (Integer)rVals[0];
        byte asnType = (Byte)rVals[1];
        if (asnType != 48) {
            throw new AsnDecodingException("Invalid SNMP variable list");
        }
        begin = offset;
        this.m_variables.clear();
        SnmpVarBind vb = new SnmpVarBind();
        for (length = ((Integer)rVals[2]).intValue(); length > 0; length -= offset - begin) {
            offset = vb.decodeASN(buf, offset, encoder);
            begin = offset;
            this.m_variables.add(vb.duplicate());
        }
        return offset;
    }

    public abstract SnmpSyntax duplicate();

    public abstract Object clone();
}

