/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.vulnscand;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.vulnscand.Range;
import org.xml.sax.ContentHandler;

public class ScanLevel
implements Serializable {
    private int _level;
    private boolean _has_level;
    private boolean _safeChecks;
    private boolean _has_safeChecks;
    private String _pluginList;
    private ArrayList _specificList = new ArrayList();
    private ArrayList _rangeList = new ArrayList();

    public void addRange(Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(vRange);
    }

    public void addRange(int index, Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(index, vRange);
    }

    public void addSpecific(String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(vSpecific);
    }

    public void addSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(index, vSpecific);
    }

    public void clearRange() {
        this._rangeList.clear();
    }

    public void clearSpecific() {
        this._specificList.clear();
    }

    public void deleteLevel() {
        this._has_level = false;
    }

    public void deleteSafeChecks() {
        this._has_safeChecks = false;
    }

    public Enumeration enumerateRange() {
        return new IteratorEnumeration(this._rangeList.iterator());
    }

    public Enumeration enumerateSpecific() {
        return new IteratorEnumeration(this._specificList.iterator());
    }

    public int getLevel() {
        return this._level;
    }

    public String getPluginList() {
        return this._pluginList;
    }

    public Range getRange(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._rangeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Range)this._rangeList.get(index);
    }

    public Range[] getRange() {
        int size = this._rangeList.size();
        Range[] mArray = new Range[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Range)this._rangeList.get(index);
        }
        return mArray;
    }

    public ArrayList getRangeCollection() {
        return this._rangeList;
    }

    public int getRangeCount() {
        return this._rangeList.size();
    }

    public boolean getSafeChecks() {
        return this._safeChecks;
    }

    public String getSpecific(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._specificList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this._specificList.get(index);
    }

    public String[] getSpecific() {
        int size = this._specificList.size();
        String[] mArray = new String[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (String)this._specificList.get(index);
        }
        return mArray;
    }

    public ArrayList getSpecificCollection() {
        return this._specificList;
    }

    public int getSpecificCount() {
        return this._specificList.size();
    }

    public boolean hasLevel() {
        return this._has_level;
    }

    public boolean hasSafeChecks() {
        return this._has_safeChecks;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeRange(Range vRange) {
        boolean removed = this._rangeList.remove(vRange);
        return removed;
    }

    public boolean removeSpecific(String vSpecific) {
        boolean removed = this._specificList.remove(vSpecific);
        return removed;
    }

    public void setLevel(int level) {
        this._level = level;
        this._has_level = true;
    }

    public void setPluginList(String pluginList) {
        this._pluginList = pluginList;
    }

    public void setRange(int index, Range vRange) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._rangeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._rangeList.set(index, vRange);
    }

    public void setRange(Range[] rangeArray) {
        this._rangeList.clear();
        for (int i = 0; i < rangeArray.length; ++i) {
            this._rangeList.add(rangeArray[i]);
        }
    }

    public void setRange(ArrayList rangeCollection) {
        this._rangeList.clear();
        for (int i = 0; i < rangeCollection.size(); ++i) {
            this._rangeList.add((Range)rangeCollection.get(i));
        }
    }

    public void setRangeCollection(ArrayList rangeCollection) {
        this._rangeList = rangeCollection;
    }

    public void setSafeChecks(boolean safeChecks) {
        this._safeChecks = safeChecks;
        this._has_safeChecks = true;
    }

    public void setSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._specificList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._specificList.set(index, vSpecific);
    }

    public void setSpecific(String[] specificArray) {
        this._specificList.clear();
        for (int i = 0; i < specificArray.length; ++i) {
            this._specificList.add(specificArray[i]);
        }
    }

    public void setSpecific(ArrayList specificCollection) {
        this._specificList.clear();
        for (int i = 0; i < specificCollection.size(); ++i) {
            this._specificList.add((String)specificCollection.get(i));
        }
    }

    public void setSpecificCollection(ArrayList specificCollection) {
        this._specificList = specificCollection;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (ScanLevel)Unmarshaller.unmarshal(ScanLevel.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

