/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.threshd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Thresholder;
import org.xml.sax.ContentHandler;

public class ThreshdConfiguration
implements Serializable {
    private int _threads;
    private boolean _has_threads;
    private ArrayList _packageList = new ArrayList();
    private ArrayList _thresholderList = new ArrayList();

    public void addPackage(Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(vPackage);
    }

    public void addPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(index, vPackage);
    }

    public void addThresholder(Thresholder vThresholder) throws IndexOutOfBoundsException {
        this._thresholderList.add(vThresholder);
    }

    public void addThresholder(int index, Thresholder vThresholder) throws IndexOutOfBoundsException {
        this._thresholderList.add(index, vThresholder);
    }

    public void clearPackage() {
        this._packageList.clear();
    }

    public void clearThresholder() {
        this._thresholderList.clear();
    }

    public void deleteThreads() {
        this._has_threads = false;
    }

    public Enumeration enumeratePackage() {
        return new IteratorEnumeration(this._packageList.iterator());
    }

    public Enumeration enumerateThresholder() {
        return new IteratorEnumeration(this._thresholderList.iterator());
    }

    public Package getPackage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._packageList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Package)this._packageList.get(index);
    }

    public Package[] getPackage() {
        int size = this._packageList.size();
        Package[] mArray = new Package[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Package)this._packageList.get(index);
        }
        return mArray;
    }

    public ArrayList getPackageCollection() {
        return this._packageList;
    }

    public int getPackageCount() {
        return this._packageList.size();
    }

    public int getThreads() {
        return this._threads;
    }

    public Thresholder getThresholder(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._thresholderList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Thresholder)this._thresholderList.get(index);
    }

    public Thresholder[] getThresholder() {
        int size = this._thresholderList.size();
        Thresholder[] mArray = new Thresholder[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Thresholder)this._thresholderList.get(index);
        }
        return mArray;
    }

    public ArrayList getThresholderCollection() {
        return this._thresholderList;
    }

    public int getThresholderCount() {
        return this._thresholderList.size();
    }

    public boolean hasThreads() {
        return this._has_threads;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removePackage(Package vPackage) {
        boolean removed = this._packageList.remove(vPackage);
        return removed;
    }

    public boolean removeThresholder(Thresholder vThresholder) {
        boolean removed = this._thresholderList.remove(vThresholder);
        return removed;
    }

    public void setPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._packageList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._packageList.set(index, vPackage);
    }

    public void setPackage(Package[] _packageArray) {
        this._packageList.clear();
        for (int i = 0; i < _packageArray.length; ++i) {
            this._packageList.add(_packageArray[i]);
        }
    }

    public void setPackage(ArrayList _packageCollection) {
        this._packageList.clear();
        for (int i = 0; i < _packageCollection.size(); ++i) {
            this._packageList.add((Package)_packageCollection.get(i));
        }
    }

    public void setPackageCollection(ArrayList _packageCollection) {
        this._packageList = _packageCollection;
    }

    public void setThreads(int threads) {
        this._threads = threads;
        this._has_threads = true;
    }

    public void setThresholder(int index, Thresholder vThresholder) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._thresholderList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._thresholderList.set(index, vThresholder);
    }

    public void setThresholder(Thresholder[] thresholderArray) {
        this._thresholderList.clear();
        for (int i = 0; i < thresholderArray.length; ++i) {
            this._thresholderList.add(thresholderArray[i]);
        }
    }

    public void setThresholder(ArrayList thresholderCollection) {
        this._thresholderList.clear();
        for (int i = 0; i < thresholderCollection.size(); ++i) {
            this._thresholderList.add((Thresholder)thresholderCollection.get(i));
        }
    }

    public void setThresholderCollection(ArrayList thresholderCollection) {
        this._thresholderList = thresholderCollection;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (ThreshdConfiguration)Unmarshaller.unmarshal(ThreshdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

